package examples.jdbc.informix4;

import java.sql.*;
import java.util.Properties;

/**
 *
 * This simple example shows how to create and execute a stored procedure
 * using an INFORMIX On-Line DBMS using JDBC.
 * <p>
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../../examples.html#environment>Setting up Your Environment for 
 * Building and Running the Examples</a>.
 * <p>
 * <li> Change connection parameters to correspond to your Informix Server configuration.
 * If you need more help, check the section on connecting
 * to a database in the programming guide, <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>.
 * <p>
 * <li>Compile this example using the following command line:
 * <pre>  $ <b>javac -d %CLIENT_CLASSES% sprocs.java</b></pre>
 * 
 * </ol>
 * <p><h3>Run the Example</h3>
 * <ol>
 * <li>Execute the following command in your development shell: 
 * 
 * <pre><b>$ java examples.jdbc.informix4.sprocs</b></pre>
 * 
 *
 * <p>The program waits after displaying output and requires you to press enter to continue.
 * </ol>
 * <p>
 * <h3>There's More</h3>
 *
 * For more information, see <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>. 
 * <p>
 * 
 * @author      Copyright (c) 1997-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class sprocs {

  /**
   * Runs the example from the command line.
   */
  public static void main(String argv[]) 
  {
    String user = "informix";
    String password = "secret";
    String server = "myDBHost";
    String port = "1493";
    String db = "myDB";
    String url = "jdbc:weblogic:informix4:myDB@myDBHost:1493";

    try {
      for (int i = 0; i < argv.length; i++) 
      {
        if (argv[i].equals("-user")) {
          i++; 
          user = (argv[i].equals("null") ? "" : argv[i]);
        } 
        else if (argv[i].equals("-password")) {
          i++; 
          password = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-server")) {
          i++; 
          server = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-port")) {
          i++; 
          port = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-db")) {
          i++; 
          db = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-url")) {
          i++; 
          url = (argv[i].equals("null") ? "" : argv[i]);
        }
      }
    } catch(ArrayIndexOutOfBoundsException aiobe) {
      System.err.println("\nUsage: java examples.jdbc.informix4.sprocs [options] \n\n" +
                         "where options include:\n" +
                         "    -user <user>            User name to be passed to database.\n" +
                         "    -password <password>    User password to be passed to database.\n" +
                         "    -server <server>        DNS name of database server.\n" +
                         "    -port <port>            Port number of database server.\n" +
                         "    -db <db>                Name of database instance.\n" +
                         "    -url <url>              URL of database.\n");
      System.exit(1);
    }

    java.sql.Connection conn         = null;
    java.sql.Statement stmt          = null;
    java.sql.CallableStatement cstmt = null;
    try {
      // Make a Connection
      Properties props = new Properties();
      props.put("user",     user);
      props.put("password", password);
      props.put("server",   server); // hostname on which Informix server runs
      props.put("port",     port);       // port on which Informix server listens
      props.put("db",       db);  // name of database on Informix server
    
      Driver myDriver = (Driver) Class.forName("weblogic.jdbc.informix4.Driver").newInstance();
      conn = myDriver.connect("jdbc:weblogic:informix4", props);

      // Create a Statement for executing queries
      stmt = conn.createStatement();

      try {
        // Try dropping the table we want to create, in case it already
        // exists
        stmt.execute("drop table demo");
        System.out.println("Table demo dropped.");
      }
      catch (SQLException e) {
        System.out.println("Table demo doesn't need to be dropped.");
      }

      try {
        // Try dropping the table we want to create, in case it already
        // exists
        stmt.execute("drop procedure sp_demo");
        System.out.println("procedure sp_demo dropped.");
      }
      catch (SQLException e) {
        System.out.println("procedure sp_demo doesn't need to be dropped.");
      }

      // Create a table by executing a query
      stmt.execute("create table demo " +
        " ( int_col INT, v_col VARCHAR(5) )");
      System.out.println("Table demo created.");

      // The results of this query aren't a ResultSet, but rather the
      // number of rows inserted into the new table.
      int numrows = stmt.executeUpdate("insert into demo " +
        " values ( 1, '11111' )");
      System.out.println("Number of rows inserted = " + numrows);

      numrows = stmt.executeUpdate("insert into demo " +
        " values ( 2, '22222' )");
      System.out.println("Number of rows inserted = " + numrows);

      // now create a stored procedure
      numrows = stmt.executeUpdate("create procedure sp_demo(col1 INT, col2 VARCHAR(5)) " +
        "RETURNING INT; " +
        "DEFINE temp_int int; " +
        "insert into demo values(col1, col2); " +
        "let temp_int = col1; " +
        "return temp_int; " +
        "END PROCEDURE;");

      // prepare the sproc call
      // note that this sproc returns a parameter, but we do not retrieve
      // it as an OUTPUT parameter.  It will go into a ResultSet instead
      // INFORMIX sprocs do not have JDBC CallableStatement OUT Parameters
      cstmt = conn.prepareCall("{ call sp_demo('6', '66666')}");

      // execute the sproc
      boolean retbool = cstmt.execute();

      if (retbool == true) {
        System.out.println("sproc returned result set");
        ResultSet rrs = cstmt.getResultSet();
        if (rrs.next()) {
          String rrs_col1 = rrs.getString(1);
          System.out.println("retrieved result = " + rrs_col1);
        } else {
          System.out.println("expected to get result from sproc !");
        }
      } else {
        System.out.println("sproc did not return result set");
      }
    } catch (Exception e) {
        System.out.println("Exception was thrown: " + e.getMessage());
    } finally {
        // Always close the Statement and the Connection when you've
        // finished working with them.
        try {
          if (stmt != null)
            stmt.close();
          if (cstmt != null)
            cstmt.close();
          if (conn != null)
            conn.close();
        } catch (SQLException sqle) {
            System.out.println("SQLException was thrown: " + sqle.getMessage());
        }
    }
  }
  
    private static void get_line(String s)
  {
    int key;
    System.out.print(s);
    System.out.flush();
    try
      {
        while ((key=System.in.read()) != 10){}
      }
    catch (Exception ex){}
  }

}

