package examples.jdbc.informix4;

import java.io.*;
import java.sql.*;
import java.util.Properties;

/**
 * This example shows how to insert string values into a column of 
 * type TEXT and then retrieve the results.
 * <p>
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../../examples.html#environment>Setting up Your Environment for 
 * Building and Running the Examples</a>.
 * <p>
 * <li> Change connection parameters to correspond to your Informix Server configuration.
 * If you need more help, check the section on connecting
 * to a database in the programming guide, <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>.
 * <p>
 * <li>Compile this example using the following command line:
 * <pre>  $ <b>javac -d %CLIENT_CLASSES% text.java</b></pre>
 * 
 * </ol>
 * <p><h3>Run the Example</h3>
 * <ol>
 * <li>Execute the following command in your development shell: 
 * 
 * <pre><b>$ java examples.jdbc.informix4.text</b></pre>
 * 
 * <h3>There's More</h3>
 *
 * For more information, see <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/index.html">Installing and Using WebLogic jDriver for Informix</a>. 
 * <p>
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc.  All Rights Reserved.
 */

public class text {

  public static void main(String argv[]) 
  {
    String user = "informix";
    String password = "secret";
    String server = "myDBHost";
    String port = "1493";
    String db = "myDB";
    String url = "jdbc:weblogic:informix4:myDB@myDBHost:1493";

    try {
      for (int i = 0; i < argv.length; i++) 
      {
        if (argv[i].equals("-user")) {
          i++; 
          user = (argv[i].equals("null") ? "" : argv[i]);
        } 
        else if (argv[i].equals("-password")) {
          i++; 
          password = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-server")) {
          i++; 
          server = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-port")) {
          i++; 
          port = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-db")) {
          i++; 
          db = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-url")) {
          i++; 
          url = (argv[i].equals("null") ? "" : argv[i]);
        }
      }
    } catch(ArrayIndexOutOfBoundsException aiobe) {
      System.err.println("\nUsage: java examples.jdbc.informix4.text [options] \n\n" +
                         "where options include:\n" +
                         "    -user <user>            User name to be passed to database.\n" +
                         "    -password <password>    User password to be passed to database.\n" +
                         "    -server <server>        DNS name of database server.\n" +
                         "    -port <port>            Port number of database server.\n" +
                         "    -db <db>                Name of database instance.\n" +
                         "    -url <url>              URL of database.\n");
      System.exit(1);
    }

    java.sql.Connection conn         = null;
    java.sql.ResultSet rs            = null;
    java.sql.Statement stmt          = null;
    java.sql.PreparedStatement pstmt = null;
    
    try {
      Properties props = new Properties();
      props.put("user",     user);
      props.put("password", password);
      props.put("server",   server); // hostname on which Informix server runs
      props.put("port",     port);       // port on which Informix server listens
      props.put("db",       db);  // name of database on Informix server

      Driver myDriver = (Driver) Class.forName("weblogic.jdbc.informix4.Driver").newInstance();
      conn = myDriver.connect("jdbc:weblogic:informix4", props);

      stmt = conn.createStatement();
      try {
        stmt.execute("drop table texttest");
      }
      catch (SQLException e) {
        // table does not exist
      }
      stmt.execute("create table texttest (foo text)");

      pstmt = conn.prepareStatement("insert into texttest(foo) values (?)");

      String strval = new String("abcdefghijklmnopqrstuvwxyz");
      pstmt.setAsciiStream(1, new ByteArrayInputStream(strval.getBytes()), strval.length());
      pstmt.executeUpdate();
      System.out.println("Inserted text into a row");

      rs = stmt.executeQuery("select foo from texttest");
      rs.next();
      System.out.println("Retrieved text from a row");

      System.out.println(rs.getString(1));
    } catch (Exception e) {
        System.out.println("Caught Exception: " + e.getMessage());
    } finally {
        try {
          if (rs != null)
            rs.close();
          if (pstmt != null)
            pstmt.close();
          if (stmt != null)
            pstmt.close();
          if (conn != null)
            conn.close();
        } catch (SQLException sqle) {
            System.out.println("SQLException was thrown: " + sqle.getMessage());
        }
    }
  }
}
