package examples.jdbc.mssqlserver4;

import java.io.*;
import java.util.*;
import java.math.*;
import java.lang.*;
import java.net.*;
import java.sql.*;

/**
 * This example shows the correct method of retrieving rows,
 * update counts, procedure status, and/or output parameters
 * from complex stored procedures that may have multiples of
 * them.
 *
 * <p>
 * <h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../../examples.html#environment>Setting up Your Environment for 
 * Building and Running the Examples</a>.
 * <p>
 * <li>Change your CLASSPATH if neccessary, depending on which version of WebLogic jDriver for Microsoft SQL Server
 * you are using. If you are using Version 7.0 you do not need to make changes. If you are using
 * Version 6.5, pre-pend your classpath as follows by adding the jar file: 
 * <pre>  $ <b>set CLASSPATH=%WL_HOME%/lib/mssqlserver4v65.jar;%CLASSPATH%</b></pre>
 * <p>
 * <li> Change the database URL, login, and password connection parameters defined in the example
 * source code to correspond to your Microsoft SQL Server configuration.
 * If you need more help, check the section on connecting
 * to a database in the programming guide, <a
 * href="http://e-docs.bea.com/wls/docs61/mssqlserver4/API_jmsq4.html">Using WebLogic jDriver for Microsoft SQL Server</a>.
 * <p>
 * <li>Compile this example using the following command line:
 * <pre>  $ <b>javac -d %CLIENT_CLASSES% complexproc.java</b></pre>
 * 
 * </ol>
 * <p><h3>Run the Example</h3>
 * <ol>
 * <li>Execute the following command in your development shell: 
 * 
 * <pre><b>$ java examples.jdbc.mssqlserver4.complexproc</b></pre>
 * 
 * </ol>
 * <h3>There's More</h3>
 *
 * For more information about the WebLogic jDriver for Microsoft SQL Server, see   <a
 * href="http://e-docs.bea.com/wls/docs61/mssqlserver4/API_jmsq4.html">Using WebLogic jDriver for Microsoft SQL Server</a>. 
 * <p>
 * @author      Copyright (c) 1997-2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class complexproc
{
  public static void main(String argv[])
  {
    String user = "sa";
    String password = "secret";
    String server = "myHost:1433";
    String url = "jdbc:weblogic:mssqlserver4";       

    try {
      for (int i = 0; i < argv.length; i++) 
      {
        if (argv[i].equals("-user")) {
          i++; 
          user = (argv[i].equals("null") ? "" : argv[i]);
        } 
        else if (argv[i].equals("-password")) {
          i++; 
          password = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-server")) {
          i++; 
          server = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-url")) {
          i++; 
          url = (argv[i].equals("null") ? "" : argv[i]);
        }
      }
    } catch(ArrayIndexOutOfBoundsException aiobe) {
      System.err.println("\nUsage: java examples.jdbc.mssqlserver4.complexproc [options] \n\n" +
                         "where options include:\n" +
                         "    -user <user>            User name to be passed to database.\n" +
                         "    -password <password>    User password to be passed to database.\n" +
                         "    -server <server>        DNS name of database server.\n" +
                         "    -url <url>              URL of database.\n");
      System.exit(1);
    }

    java.sql.Connection conn         = null; 
    java.sql.Statement stmt          = null;
    java.sql.CallableStatement cstmt = null;
    java.sql.ResultSet rs            = null;

    try {
      java.util.Properties props = new java.util.Properties();
      props.put("user",     user);
      props.put("password", password);
      props.put("server",   server);
    
      Driver myDriver = (Driver)    
          Class.forName("weblogic.jdbc.mssqlserver4.Driver").newInstance();
      conn = myDriver.connect("jdbc:weblogic:mssqlserver4", props);
    
      String setup_proc =
        " if exists (select * from sysobjects where id = "
        + " object_id('dbo.sp_myname') and sysstat & 0xf = 4) "
        + " drop procedure dbo.sp_myname";
    
      String big_proc =
        " create procedure sp_myname @aname varchar(30) output as "
        + " begin                                                   "
        + "    declare @string varchar(30)                          "
        + "    select @aname = 'no name'                            "
        + "    declare @tmp_return_code INT                         "
        + "    declare str_cursor cursor for                        "
        + "       select name from master.dbo.sysdatabases          "
        + "       for read only                                     "
        + "    IF @@ERROR != 0                                      "
        + "    begin                                                "
        + "        RETURN @@ERROR                                   "
        + "    end                                                  "
        + "    open str_cursor                                      "
        + "    IF @@ERROR != 0                                      "
        + "    begin                                                "
        + "      RETURN @@ERROR                                     "
        + "    end                                                  "
        + "                                                         "
        + "    fetch str_cursor into @string                        "
        + "                                                         "
        + "    SELECT @tmp_return_code = @@ERROR                    "
        + "    IF @tmp_return_code != 0                             "
        + "    begin                                                "
        + "        GOTO WAY_OUT                                     "
        + "    end                                                  "
        + "                                                         "
        + "    WHILE (@@fetch_status = 0)                           "
        + "      BEGIN                                              "
        + "         FETCH str_cursor INTO @string                   "
        + "                                                         "
        + "          IF @@fetch_status = -1                         "
        + "          begin                                          "
        + "            select @tmp_return_code = 88                 "
        + "            GOTO WAY_OUT                                 "
        + "          end                                            "
        + "                                                         "
        + "          IF @@fetch_status = -2                         "
        + "          begin                                          "
        + "            select @tmp_return_code = 77                 "
        + "            GOTO WAY_OUT                                 "
        + "          end                                            "
        + "                                                         "
        + "          select @aname = @string                        "
        + "          SELECT @tmp_return_code = @@ERROR              "
        + "          IF @tmp_return_code != 0                       "
        + "          begin                                          "
        + "              RETURN @tmp_return_code                    "
        + "          end                                            "
        + "                                                         "
        + "       END                                               "
        + "                                                         "
        + " WAY_OUT:                                                "
        + "   CLOSE str_cursor                                      "
        + "   DEALLOCATE  str_cursor                                "
        + "   select @aname                                         "
        + "   return @tmp_return_code                               "
        + "                                                         "
        + " end                                                     ";
    
      stmt = conn.createStatement();
      stmt.executeUpdate ( setup_proc );
      System.out.println("setup_proc executed\n");
      stmt.executeUpdate ( big_proc );
      cstmt = conn.prepareCall("{ ? = call sp_myname(?)}");
    
      cstmt.registerOutParameter(1, java.sql.Types.INTEGER);
      cstmt.registerOutParameter(2, java.sql.Types.VARCHAR);
      
      boolean hasResultSet = cstmt.execute();
    
      while (true)
      {
        rs    = cstmt.getResultSet();
	int updateCount = cstmt.getUpdateCount();
	
        // If there are no more results or counts, we're done.
        if (rs == null && updateCount == -1)
          break; 
      
        // Check to see if there is a ResultSet
        if (rs != null) {
          while (rs.next()) {
            System.out.println("Get first col by id:" + rs.getString(1));
          }
          rs.close();
        } // Otherwise, there will be an update count
        else {
          System.out.println("Update count = " + cstmt.getUpdateCount());
        }
        cstmt.getMoreResults();
      }
    
      // Best to retrieve status after all result sets and update counts
      // have been retrieved.
      System.out.println( "Output status: " + cstmt.getInt(1));
      System.out.println( "Output param:  " + cstmt.getString(2));

    } catch (Exception e) {
        System.out.println("Exception was trown: " + e.getMessage());
    } finally {
        try {
          if (rs != null)
            rs.close();
          if (cstmt != null)
            cstmt.close();
          if (stmt != null)
            stmt.close();
          if (conn != null)
            conn.close();
       } catch (SQLException sqle) {
           System.out.println("SQLException during close(): " + sqle.getMessage());
       }
    }
  }
}
