package examples.jdbc.mssqlserver4;

import java.sql.*;
import java.util.Properties;


/**
 * This simple example shows the alternatives for making a
 * JDBC connection to a MSSQLServer instance.
 * <p><h3>Building and running the example:</h3>
 *
 * <ol>
 * <p>
 * <li> Open a new command shell.
 * <p><li>Set up this development shell as described in
 * <a href=../../examples.html#environment>Setting up Your Environment for
 * Building and Running the Examples</a>.
 * <p>
 * <li>Change your CLASSPATH if neccessary, depending on which version of WebLogic jDriver for Microsoft SQL Server
 * you are using. If you are using Version 7.0 you do not need to make changes. If you are using
 * Version 6.5, pre-pend your classpath as follows by adding the jar file:
 * <pre>  $ <b>set CLASSPATH=%WL_HOME%/lib/mssqlserver4v65.jar;%CLASSPATH%</b></pre>
 * <p>
 * <li> Change the database URL, login, and password connection parameters defined in the example source code
 * to correspond to your Microsoft SQL Server configuration. (Change the hostname and port number used to
 * connect to your SQL Server installation.) If you need more help, check the section on connecting
 *  to a database in the Developers Guide, <a
 * href="http://e-docs.bea.com/wls/docs61/mssqlserver4/API_jmsq4.html">Using WebLogic jDriver for Microsoft SQL Server</a>.
 *
 * <p>
 *
 * <li>Compile this example by executing the following command in your development shell:
 *
 * <p>
 *
 * <pre><font face="Courier New"><b>$ javac -d %CLIENT_CLASSES% login.java</b></font></pre>
 * <p>
 *
 * <li>Run this example by executing the following command in your development shell:
 *
 * <p>
 *
 * <pre><font face="Courier New"><b>$ java examples.jdbc.mssqlserver4.login</b></font></pre>
 *
 * </ol><p>
 * <h3>There's More</h3>
 *
 * For more information about the WebLogic jDriver for Microsoft SQL Server, see   <a
 * href="http://e-docs.bea.com/wls/docs61/mssqlserver4/API_jmsq4.html">Using WebLogic jDriver for Microsoft SQL Server</a>.
 * <p>
 *
 * @author       Copyright (c) 1997-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class login {

  public static void main(String argv[])
  {
    String user = "sa";
    String password = "secret";
    String server = "myHost:1433";
    String url = "jdbc:weblogic:mssqlserver4";       

    try {
      for (int i = 0; i < argv.length; i++) 
      {
        if (argv[i].equals("-user")) {
          i++; 
          user = (argv[i].equals("null") ? "" : argv[i]);
        } 
        else if (argv[i].equals("-password")) {
          i++; 
          password = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-server")) {
          i++; 
          server = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-url")) {
          i++; 
          url = (argv[i].equals("null") ? "" : argv[i]);
        }
      }
    } catch(ArrayIndexOutOfBoundsException aiobe) {
      System.err.println("\nUsage: java examples.jdbc.mssqlserver4.login [options] \n\n" +
                         "where options include:\n" +
                         "    -user <user>            User name to be passed to database.\n" +
                         "    -password <password>    User password to be passed to database.\n" +
                         "    -server <server>        DNS name of database server.\n" +
                         "    -url <url>              URL of database.\n");
      System.exit(1);
    }

    java.sql.Connection conn = null;
    //
    // This method uses a Properties object to pass the connection information
    // and the connection is made with the Driver.connect() method.
    // The optional "appname" and "hostname" properties are passed to MS SQL server
    // and can be read in the sysprocesses table under the column names
    // "program_name" and "hostname". The hostname value will be prepended with "WebLogic"
    // Change "myhost:1433" to the host name and port number of your SQL Server.
    //
    Properties props = new Properties();
    props.put("user",     user);
    props.put("password", password);
    props.put("db",       "pubs");
    props.put("server",   server);
    props.put("appname",  "MyApplication");
    props.put("hostname", "myhostName");

    try {
      Driver myDriver = (Driver) Class.forName("weblogic.jdbc.mssqlserver4.Driver").newInstance();
      conn = myDriver.connect("jdbc:weblogic:mssqlserver4", props);
      System.out.println("Logged in successfully");
    } catch (Exception e) {
        System.out.println("Exception was thrown: " + e.getMessage());
    } finally {
        try {
          if (conn != null)
            conn.close();
        } catch (SQLException sqle) {
            System.out.println("SQLException was thrown: " + sqle.getMessage());
        }
    }
  }
}



