package examples.jms.startup;

import javax.jms.*;

/**
 * This example implements the message listener interface. The 
 * WebLogic Server can be configured to manage a pool of 
 * message listeners. Messages matching a particular
 * selection criteria are processed in parallel by listeners
 * in the pool.  This class is used by the 
 * <font face="Courier New" size = -1><a href="PoolReceive.html">PoolReceive</a></font> example.
 * <p>
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class MsgListener
  implements MessageListener
{
  private static int listenerCounter=0;  // global count of MsgListeners
  private int listenerId; // identifies a particular listener

  public MsgListener()
  {
    this.listenerId = ++listenerCounter;
  }

  /** Message listener interface.
    * @param msg message
    */
  public void onMessage(Message msg)
  {
    try {
      String msgText;
      if (msg instanceof TextMessage) {
        msgText = ((TextMessage)msg).getText();
      } else {
        msgText = msg.toString();
      }
      System.out.println("MsgListener["+listenerId+"] : JMS Message="+ msgText);

      // The sleep() is for demonstration purposes only; without it
      // the same MsgListener tends to get used to service incoming messages,
      // making it harder to show the pool in action.
      try {
        Thread.sleep(1000);
      } catch (InterruptedException ie) {}
    } catch (JMSException jmse) {
      jmse.printStackTrace();
    }
  }


}




