package examples.jms.startup;

import java.io.*;
import java.util.*;
import javax.transaction.*;
import javax.naming.*;
import javax.jms.*;
import weblogic.common.*;

/**
 * This example  
 * establishes a single message listener. As messages are 
 * received from the topic, they are displayed in the shell 
 * running the WebLogic Server and written to the <tt>weblogic.log</tt> file. 
 * You can use the <font face="Courier New" size = -1>
 * <a href="../topic/package-summary.html">TopicSend</a></font> client 
 * to send messages to the topic.
 * <p>The following sections describe how to:
 * <p>
 * <ol>
 * <li><a href="#Build the example">Build the example</a>
 * <li><a href="#Configure the server">Configure the server</a>
 * <li><a href="#Run the example">Run the example</a>
 * </ol> 
 * <p>
 * <h3><a name="Build the example">Build the Example</a></h3>
 * <p>
 * <ol>
 * <li>Set up your development shell, as described in 
 * <a href=../../examples.html#environment>Setting up 
 * your environment</a>.
 * <li>
 * Compile the example by executing the following command or by executing the <a href=../../examples.html#buildScripts>build script</a> 
 * provided for this example in the <font face="Courier New" size = -1>samples/examples/jms/startup</font> 
 * directory. The script will perform the following step:
 * <p> 
 * Compile the ServerReceive as shown in this example for <b>Windows NT/2000</b>: 
 * <p><pre>  $<font face="Courier New"><b> javac -d %SERVER_CLASSES% ServerReceive.java</b></font></pre>
 * </ol> 
 * <p><h3><a name="Configure the server">Configure the Server</a></h3>
 * The WebLogic startup class has been preconfigured for your convenience. You
 * must deploy the startup class on the server, as described in the 
 * following procedure.
 * <p>
 * To configure the server: 
 * <ol>
 * <li>
 * <a href=../../examples.html#startServer>Start the server with the examples configuration</a>.
 * <li>
 * Bring up the <a href="../../examples.html#console">Administration Console</a> in your browser.
 * <li>
 * Click to expand the Deployments node in the left pane.
 * <li>
 * Click to expand the Startup & Shutdown node in the left pane.
 * <li>
 * Choose the server target for the serverReceive startup class as follows:
 * <ol type ="a">
 * <li>
 * Select the serverReceive node.
 * The serverReceive startup class configuration information displays
 * in the right pane.
 * <li>
 * Select the Targets tab in the right pane to display the Available and Chosen
 * targets.
 * <li>
 * Move the examplesServer target to the Chosen column and click the Apply button to 
 * save the assignment.
 * </ol>
 * <b>Note:</b> If you have configured the server to run the <a href="../topic/package-summary.html"><tt>examples.jms.topic</tt></a>
 * example, then no additional configuration changes are required to run the 
 * <tt>ServerReceive</tt> example. You can skip to the section <a href="#Run the example">Run the Example</a>.
 * <li>
 * Click to expand the JMS node in the left pane.
 * <li>
 * Click to expand the JMS Connection Factories node in the left pane.
 * <li>
 * Choose the server target for the exampleTopic connection factory as follows:
 * <ol type="a">
 * <li>
 * Select the exampleTopic node. 
 * The exampleTopic connection factory configuration information displays 
 * in the right pane. 
 * <li>
 * Select the Targets tab in the right pane to display the Available and Chosen
 * targets.
 * <li>
 * Move the examplesServer target to the Chosen column and click the Apply button to 
 * save the assignment.
 * </ol>
 * <p>
 * <b>Note:</b> Normally, you would also have to choose one or more targets for the JMS server
 * associated with the topic.
 * For your convenience, the examplesJMSServer server
 * has been preconfigured to include the examplesServer as a chosen target.
 * </ol>
 * <h3><a name="Run the example"></a>Run the Example</h3>
 * <ol>
 * <li>
 * <a href="../../examples.html#startServer">Restart the server</a> to 
 * invoke the startup class.
 * <li>
 * Start the <font face="Courier New" size = -1>
 * <a href=../topic/TopicSend.html>TopicSend</a></font> client in your 
 * development shell and send messages to the topic.
 * The <font face="Courier New" size = -1>
 * ServerReceive</font> startup class displays messages in the shell running 
 * WebLogic Server and writes them to the <tt>weblogic.log</tt> file
 * as they are 
 * received from the topic. 
 * </ol>
 *
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class ServerReceive
  implements MessageListener, T3StartupDef
{
  private T3ServicesDef services;
  private TopicConnectionFactory tconFactory;
  private TopicConnection tcon;
  private TopicSession tsession;
  private TopicSubscriber tsubscriber;
  private Topic topic;

  /**
   * Passes to the
   * startup class the handle of an object that can be used 
   * to access WebLogic services. This makes another reference 
   * to the services object so it can be used later.
   *
   * @param services          services stub
   */
  public void setServices(T3ServicesDef services) {
    this.services = services;
  }

  /**
   * Creates a consumer.
   * @param	name name
   * @param args environment
   * @exception Exception if problem occurs
   */
  public String startup(String name, Hashtable args) 
       throws Exception 
  {
    //Thread.sleep(120000);
    String connectionFactory = (String)args.get("connectionFactory");
    String topicName = (String)args.get("topic");

    if (connectionFactory == null || topicName == null) {
      throw new IllegalArgumentException("connectionFactory="+connectionFactory+
                                         ", topicName="+topicName);
    }

    Context ctx = new InitialContext();
    tconFactory = (TopicConnectionFactory) ctx.lookup(connectionFactory);
    tcon = tconFactory.createTopicConnection();
    tsession = tcon.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
    topic = (Topic) ctx.lookup(topicName);
    tsubscriber = tsession.createSubscriber(topic);
    tsubscriber.setMessageListener(this);
    tcon.start();
    return "Ready To Receive Messages";
  }

  // MessageListener interface
  /**
    * Message listener interface.
    * @param msg message
    */
  public void onMessage(Message msg)
  {
    try {
      String msgText = ((TextMessage)msg).getText();
      services.log().info("JMS Message Received: "+ msgText);
      System.out.println("JMS Message Received: "+ msgText);
    } catch (JMSException jmse) {
      jmse.printStackTrace();
    } catch (T3Exception t3e) {
      t3e.printStackTrace();
    }
  }

}






