
package examples.jms.trader;

import java.io.*;
import javax.naming.*;
import javax.jms.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * Sends a <i>buy</i> or <i>sell</i> message to a topic. 
 * The <font face="Courier New" size = -1>TraderReceive</font> client receives the messages and 
 * invokes an EJBean to process the messages.
 *
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class TraderServlet extends HttpServlet
{
/**
 * Defines JMS connection factory. 
 */
  public final static String JMS_FACTORY="jms.connection.traderFactory";
/**
 * Defines JMS topic. 
 */
  public final static String TOPIC="weblogic.examples.jms.exampleTopic";

 /**
   * service() method.
   * @param req	HTTP servlet request
   * @param res	HTTP servlet response
   * @exception IOException if problem occurs with an I/O operation
   * @exception ServletException if problem occurs with servlet operation
  */
   
  public void service(HttpServletRequest req, HttpServletResponse res)
       throws IOException, ServletException
  {
    String custName;
    String tradeType;
    String symbol;
    int shares;
    try {
      if (req.getMethod().equals("GET")) {
        PrintWriter pw = new PrintWriter(res.getOutputStream(),true);
        printForm(pw);
      } else {
        custName = req.getParameterValues("custname")[0];
        tradeType = req.getParameterValues("tradetype")[0];
        symbol = req.getParameterValues("symbol")[0];
        shares = Integer.parseInt(req.getParameterValues("shares")[0]);

        sendTopicMessage(custName, tradeType, symbol, shares);
      
        res.setContentType("text/html");
        res.setHeader("Pragma", "no-cache");
        PrintWriter pw = new PrintWriter(res.getOutputStream(),true);
        pw.println("<HTML><HEAD><TITLE>Message Status</TITLE></HEAD>");
        pw.println("<BODY><img src=images/BEA_Button_Final_web.gif align=right>");
	pw.println("Message Submitted");
        pw.println("</BODY></HTML>");
        pw.close();
        return;
      }
    }
    catch (Exception e) {e.printStackTrace();
    }

  }
 /**
   * Prints form. 
   * @param pw print writer
   * @exception Exception if problem occurs 
  */

  public void printForm(PrintWriter pw) 
       throws Exception
  {
    pw.println("<HTML><HEAD><TITLE>Message Status</TITLE></HEAD>");
    pw.println("<BODY>");
    pw.println("<p><img src=images/BEA_Button_Final_web.gif align=right>");
    pw.println("<FORM METHOD=\"POST\" ACTION=\"./jmstrader\">");
    pw.println("<TABLE>");
    pw.println("<TR><TD>Customer Name:</TD><TD><INPUT NAME=\"custname\" SIZE=40></TD></TR>");
    pw.println("<TR><TD>Trade:</TD>");
    pw.println("<TD><select name=tradetype>");
    pw.println("<option value=buy selected>Buy");
    pw.println("<option value=sell>Sell");
    pw.println("</select>");
    pw.println("</TR>");
    pw.println("<TR><TD>Stock:</TD>");
    pw.println("<TD><select name=symbol>");
    pw.println("<option value=WEBL selected>BEA Systems");
    pw.println("<option value=INTL>Intel Corp");
    pw.println("</select>");
    pw.println("</TR>");
    pw.println("<TR><TD>Number of Shares:</TD><TD><INPUT NAME=\"shares\" SIZE=10></TD></TR>");
    pw.println("<TR><TD></TD><TD><INPUT TYPE=\"submit\" VALUE=\"Send Message\"></TD></TR>");
    pw.println("</TABLE>");
    pw.println("</FORM>");
    pw.println("</BODY></HTML>");
    pw.close();
  }
 /**
   * Sends topic message. 
   * @param customerName customer name
   * @param tradeType	 trade type
   * @param symbol	 symbol
   * @param shares	 shares
   * @exception NamingException if problem occurs with JNDI context interface
   * @exception JMSException if JMS fails to send topic message due to internal error 
  */

  public void sendTopicMessage(String customerName, String tradeType, 
                               String symbol, int shares)
       throws NamingException, JMSException
  {
    Context ctx = new InitialContext();
    TopicConnectionFactory tconFactory;
    TopicConnection connection;
    TopicSession session;
    TopicPublisher publisher;
    Topic topic;
    MapMessage msg;

    tconFactory = (TopicConnectionFactory) ctx.lookup(JMS_FACTORY);
    connection = tconFactory.createTopicConnection();
    session = connection.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
    topic = (Topic) ctx.lookup(TOPIC);
    publisher = session.createPublisher(topic);
    msg = session.createMapMessage();
    msg.setString("CustomerName", customerName);
    msg.setString("TradeType", tradeType);
    msg.setString("Symbol", symbol);
    msg.setInt("Shares", shares);
    msg.setBooleanProperty("tracing", true);

    publisher.publish(msg, DeliveryMode.PERSISTENT, 9, 0);

    publisher.close();
    session.close();
    connection.close();
  }
}



