package examples.jsp.tagext.counter;

import java.io.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.servlet.http.*;

/**
 * This class displays a graphical page-hits count in a JSP page. 
 */

public class Display extends TagSupport {
  
  
  private static String IMAGE_DIR="images/numbers/";
  
  public int doStartTag() throws JspException {
      
    File tempDir = (java.io.File) pageContext.getServletContext().
       getAttribute("javax.servlet.context.tempdir");
    
    File countFile = new File(tempDir, "count.tmp");
    
    String countStr = String.valueOf(Count.getCount(countFile));
    
    try {
      JspWriter out = pageContext.getOut();
      int i = 0;
      while(i < countStr.length())
      {
        out.print("<img src=\""+IMAGE_DIR+countStr.charAt(i)+
                  ".gif\" height=40 >");
        i++;
      }
    } catch(IOException ioe) {
      System.out.println("Failed to insert counter display");
      ioe.printStackTrace();
      throw new JspException("Failed to insert counter display");
    }
    
    return(SKIP_BODY);
  }
}
  

