<%@ taglib uri="tagl" prefix="wl" %>

<!-- The wl:summary tag is required -->
<wl:summary 
 name="summary"
 headerText="<h4>Some fields have not been filled out correctly:</h4>"
 redirectPage="successPage.jsp"
>

<html>
<head>
 <title>BEA WebLogic Server Form Validation Tags Example</title>
 <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
</head>

<body bgcolor="#FFFFFF">
<font face="Helvetica" size=2>
<img src="images/BEA_Button_Final_web.gif" align=right>
<h1>WebLogic JSP Form Validation Tags Example</h1>

This JSP page demonstrates the use of the WebLogic Form Validation Tags. Form
Validation Tags are used to validate the text input by users into HTML
forms. This page demonstrates three types of form validation:

<ul>
<li><a href=#reqired>Required Field</a>
<li><a href=#compare>Compare Field</a>
<li><a href=#regexp>Regular Expression</a>
</ul>

<p>This example also demonstrates how to display an <a
href=#errorlist>error summary</a> returned by the Form Validation
Tags. The text displayed is defined by the <font face="Courier New">errorMessage</font> attribute of the <font face="Courier New">&lt;wl:validator&gt;</font> tag.

<p>Try entering text into the form fields below and then press the
Submit button. If the Form Validation Tags find errors, the page is
re-displayed showing the errors. If all fields are filled in
correctly, you are re-directed to a page indicating success.

<p>For more information, see <a
href="http://e-docs.bea.com/wls/docs61/jsp/validation_tags.html">Using WebLogic JSP Form
Validation Tags</a>.

<p>
<a name="required"></a>
<table width=500 border=0  bgcolor="dddddd">
<tr><td colspan=3><font face="Helvetica" size=2>
<h3>Required Field Validation</h3>

The Required Field Validation tag verifies that text has been input
into the field.

<p></th></tr><font face="Helvetica" size=2>
<wl:form method="POST" action="successPage.jsp" name="rfv">
<tr>
<td width=33% ><font face="Helvetica" size=2> User Name: </td>
<td width=33% ><font face="Helvetica" size=2>
  <input type="text" name="username" value="<%= request.getParameter("username") %>">
</td>

<td  width=33% ><font face="Helvetica" size=2> 
<wl:validator 
   fieldToValidate="username" 
   validatorClass="weblogicx.jsp.tags.validators.RequiredFieldValidator"
   errorMessage="User name is a required field."
>
  <img src=images/warning.gif> <font color="red">This is a required field.</font>
</wl:validator>

</td></tr>	

</table>

<p>


<p>
<a name="compare"></a>
<table width=500 border=0  bgcolor="dddddd"><tr><td colspan=3>
<font face="Helvetica" size=2>
<h3>Compare Field Validation</h3>

The Compare Field Validation tag checks to see if two fields have
identical input. It is useful for making sure a user enters a new
password correctly. Required Field Validation tags are also used for
these fields.

<p>

</td></tr>
<font face="Helvetica" size=2>
<tr>
<td><font face="Helvetica" size=2> Password:</td>
<td  width=33% ><font face="Helvetica" size=2> 
 <input type="password" name="password" value="<%= request.getParameter("password") %>">
</td>

<td  width=33% ><font face="Helvetica" size=2>
<wl:validator 
   fieldToValidate="password" 
   validatorClass="weblogicx.jsp.tags.validators.RequiredFieldValidator"
   errorMessage="Password is a required field."
 >

 <img src=images/warning.gif> <font color="red">This is a required field.</font>
</wl:validator>
</td></tr>

<tr><td  width=33% ><font face="Helvetica" size=2> Re-enter Password:</td>
<td  width=33% ><font face="Helvetica" size=2>
 <input type="password" name="password2" value="<%= request.getParameter("password2") %>">
</td>
<td> <font face="Helvetica" size=2>

<wl:validator 
   fieldToValidate="password,password2" 
   validatorClass="weblogicx.jsp.tags.validators.CompareValidator"
   errorMessage="Passwords don't match."
 >
   <img src=images/warning.gif> <font color="red">Passwords don't match.</font>
</wl:validator>


<wl:validator 
   fieldToValidate="password2" 
   validatorClass="weblogicx.jsp.tags.validators.RequiredFieldValidator"
   errorMessage="Re-enter password is a required field."
 >

 <img src=images/warning.gif> <font color="red">This is a required field.</font>
</wl:validator>
</td>
</tr>

</table>

<p>

<a name="regexp"></a>
<table width=500 border=0 bgcolor="dddddd"><tr><td colspan=3>
<font face="Helvetica" size=2>
<h3>Regular Expression Validation</h3>

<p>The Regular Expression Validation tag validates the input using a
regular expression. This example checks to see if the input is in the
form <font face="Courier New"
size=-1><i>somestring</i>@<i>somestring</i>.net,com, or org</font>.  A
Required Field Validation tag is also used.

<p>The regular expression used to validate the field is:<br> 
<font face="Courier New" size=-1>
\\S+@\\S+\\.(com|org|net)</font>

<p>

</td></tr>

<tr>
<td width=33% ><font face="Helvetica" size=2> Email address: </td>
<td width=33% ><font face="Helvetica" size=2>
 <input type="text" name="email" value=<%= request.getParameter("email") %>>
</td>
<td  width=33% ><font face="Helvetica" size=2> 

<wl:validator 
 fieldToValidate="email" 
 validatorClass="weblogicx.jsp.tags.validators.RegExpValidator"
 errorMessage="Invalid Email address."
 expression="\\S+@\\S+\\.(com|org|net)"  
 >

 <img src=images/warning.gif> <font color="red">Invalid email address.</font>
</wl:validator>

<wl:validator 
   fieldToValidate="email" 
   validatorClass="weblogicx.jsp.tags.validators.RequiredFieldValidator"
   errorMessage="Email is a required field."
 >
   <img src=images/warning.gif> <font color="red">This is a required field.</font>
</wl:validator>

</td></tr>	
</table>

<P> <input type="submit" value="Submit">

</wl:form>

<a name="errorlist"></a>
<table width=500 border=0 bgcolor="aaaaaa"><tr><td >
<font face="Helvetica" size=2>

<a name="errorsummary"></a>	
<h3>Error Summary</h3>

A listing of all errors returned by Form Validation Tags used on this
page is generated here.
<p>
<!-- The wl:errors tag lists all of the errors on the page, one per line -->
<wl:errors color="red" />

<p>

</td></tr></table>


</wl:summary>

<hr>
<font size=-1>
Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
</font>

</body>
</html>