package examples.rmi.hello;

import java.io.PrintStream;
import weblogic.utils.Debug;
import javax.naming.*;
import java.util.Hashtable;

/**
 * This client uses the remote HelloServer methods.
 *
 * @author Copyright (c) 1997 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class HelloClient {

  private final static boolean debug = true;

/**
 * Defines the JNDI context factory.
 */
  public final static String JNDI_FACTORY="weblogic.jndi.WLInitialContextFactory";
  
  int port;
  String host;
  
  private static void usage() {
    System.err.println("Usage: java examples.rmi.hello.HelloClient " +
                       "<hostname> <port number>");
    System.exit(-1);
  } 
  
  public HelloClient() {}
  
  public static void main(String[] argv) throws Exception {
    if (argv.length < 2) {
      usage();
    }
    String host = argv[0];
    int port = 0;
    try {
      port = Integer.parseInt(argv[1]);
    }
    catch (NumberFormatException nfe) {
      usage();
    }
    try {

      InitialContext ic = getInitialContext("t3://" + host + ":" + port);

      Hello obj = 
        (Hello) ic.lookup("HelloServer");
      System.out.println("Successfully connected to HelloServer on " +
                         host + " at port " +
                         port + ": " + obj.sayHello() );
    }
    catch (Throwable t) {
      t.printStackTrace();
      System.exit(-1);
    }
  }

  private static InitialContext getInitialContext(String url)
       throws NamingException
  {
    Hashtable env = new Hashtable();
    env.put(Context.INITIAL_CONTEXT_FACTORY, JNDI_FACTORY);
    env.put(Context.PROVIDER_URL, url);
    return new InitialContext(env);
  }


}
