/*
 * Copyright (c) 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */
package examples.rmi.hello;

import javax.naming.*;
import weblogic.rmi.RMISecurityManager;
import java.rmi.RemoteException;

/**
 * This simple example is available as part of Sun's distribution
 * package. We've just changed the package statement and import
 * statements to work with WebLogic RMI.
 * <p>
 * Note that with WebLogic RMI, you don't need to extend
 * UnicastRemoteObject.  Also, you don't need to set a
 * SecurityManager, although you can set one if desired. WebLogic RMI
 * uses security measures (like SSL) that are build into WebLogic,
 * rather than implementing a special case of security for remote
 * objects.
 *
 * @author Copyright (c) 1997-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class HelloImpl implements Hello
// This is unecessary in WebLogic RMI
// extends UnicastRemoteObject 
{   
  private String name;

  /**
   * Constructs a HelloImpl with the specified string.
   *
   * @param s                 String message
   */
  public HelloImpl(String s) throws RemoteException {
    super();
    name = s;
  }

  /**
   * Returns a string.
   *
   * @return                  String message
   * @exception               java.rmi.RemoteException
   */
  public String sayHello() throws java.rmi.RemoteException {
    return  "Hello World!";
  }

  /**
   * Allows the WebLogic Server to instantiate this implementation
   * and bind it in the registry.
   */
  public static void main(String args[]) {
    // Creating and installing the security manager
    // is unnecessary with WebLogic RMI
    if (System.getSecurityManager() == null)
      System.setSecurityManager(new RMISecurityManager());
    
    try {
      HelloImpl obj = new HelloImpl("HelloServer");
      Context ctx = new InitialContext();
      ctx.bind("HelloServer", obj);
      System.out.println("HelloImpl created and bound in the registry " +
                         "to the name HelloServer");
      
    }
    catch (Exception e) {
      System.out.println("HelloImpl.main: an exception occurred:");
      e.printStackTrace();
    }
  }
}

