package examples.rmi.multihello;

import javax.naming.*;
import java.rmi.RemoteException;

/**
 * This remote class implements the Hello remote interface, which returns a
 * 'hello' message identifying this class instance by name. 
 * <p>
 * The main() method registers 10 instances of this class in 
 * the RMI registry of the WebLogic Server. For this example, you should
 * register this class as a startupClass in the Administration Console.
 * This will cause main() to be invoked when you start the WebLogic Server, and 
 * thus will instantiate 10 instances and register them in the RMI registry. 
 * 
 * In this example, the <tt>ClientApp</tt> Java application invokes
 * the sayHello() remote methods on each of the remote instances of this class
 * multiple times via different protocols with WebLogic RMI. 
 *
 * @author Copyright (c) 1997-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class HelloImpl implements Hello 
  // This is unecessary in WebLogic RMI
  // extends UnicastRemoteObject 
{
  private String name;
  private int cnt = 0;

  /**
   * Creates a HelloImpl with the specified string.
   *
   * @param s                 String message
   * @exception               java.rmi.RemoteException
   *                          if the impl cannot be created
   */
  public HelloImpl(String s) throws java.rmi.RemoteException {
    name = s;
  }

  /**
   * Returns the string message for a HelloImpl.
   *
   * @return                  String message
   * @exception               java.rmi.RemoteException if there is an error
   */
  public String sayHello() throws java.rmi.RemoteException {
    return "Hello! From " + name; // + " " + cnt++;
  } 

  /**
   * Creates and binds 10 HelloImpl objects in the WebLogic Server
   * and binds each to a unique name.
   */
  public static void main(String args[]) {
    
    // Unnecessary in WebLogic RMI
    // System.setSecurityManager(new RMISecurityManager());

    int i = 0;
    try {
      Context ctx = new InitialContext();
      for (i = 0; i < 10; i++) {
        HelloImpl obj = new HelloImpl("MultiHelloServer" + i);
        ctx.bind("MultiHelloServer" + i, obj);
        System.out.println("MultiHelloServer" + i + " created.");
      }
      System.out.println("Created and registered " + i + " MultiHelloImpls.");
      
    }
    catch (Exception e) {
      System.out.println("HelloImpl err: " + e.getMessage());
      e.printStackTrace();
    }
  }
}

