package examples.rmi.multihello;

import javax.naming.*;
import java.util.Hashtable;

/**
 * This simple example uses WebLogic RMI to say "Hello World" multiple
 * times. Note that there is no explicit creation of a T3Client nor
 * connection to a WebLogic Server, although this program runs as a
 * T3Client application.
 *
 * @author Copyright (c) 1997-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class sayHello {

  /**
   * Defines the JNDI context factory.
   */
  public final static String JNDI_FACTORY="weblogic.jndi.WLInitialContextFactory";

  /**
   * Runs this example from the command line.
   */
  public static void main(String argv[]) throws Exception {
    if (argv.length < 1) {
      usage();
    }
   InitialContext ctx = getInitialContext(argv[0]);

    for (int i = 0; i < 10; i++) {
      Hello obj = (Hello)ctx.lookup("MultiHelloServer" + i);
      for (int j = 0; j < 10; j++) {
	obj.sayHello();
	System.out.println(obj.sayHello() + " " + j);
      }
    }
  }

  private static void usage() {
    System.err.println("Usage: java examples.rmi.multihello.sayHello " +
                       "t3://<hostname>:<port number>");
    System.exit(-1);
  } 

  private static InitialContext getInitialContext(String url)
       throws NamingException
  {
    Hashtable env = new Hashtable();
    env.put(Context.INITIAL_CONTEXT_FACTORY, JNDI_FACTORY);
    env.put(Context.PROVIDER_URL, url);
    return new InitialContext(env);
  }
}

