use File::Find;

sub BEGIN{
    # prime @ARGV with list of .java files in the current dir and below 
    # Use File::Find::find to get a list of such files. 
    find (sub { # Called for each file and directory
               # $File::Find::name contains name of found file/dir
               push(@ARGV, $File::Find::name) if /[.]java$/;
           },
          '.'); # Start from current directory
}; 

$^I = '.bak'; # Enable in-place editing, and make .bak the  suffix 
              # of the backup file 

# For each line, for each file in @ARGV, do the substitution
# java.rmi gets changed to weblogic.rmi
while (<>) {
    s/\bjava\.rmi/weblogic.rmi/g ;# \b represents word boundary
    print;
}
