package examples.security.acl;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;

/** 
 * This simple client connects as a specific user and
 * attempts an RMI invocation. Access to the invocation will be
 * granted or denied depending on the configured ACLs.
 *
 * @author Copyright (c) 1997-2001 by BEA Systems, Inc. All Rights Reserved.
 * @see <a href="AltClient.html">AltClient</a>
 */
public class Client {

  /** 
   * Checks the parameters, looks up <tt>frob target</tt>, calls
   * <tt>frob</tt> on it, and reports on the success. 
   */
  public static void main(String[] arg) {
    Context ctx = null;
    
    if (arg.length != 3) {
      System.out.println("Usage:   java examples.security.acl.Client " +
                         "URL username password");
      System.out.println("Example: java examples.security.acl.Client " +
                         "t3://localhost:7001 guest guest");
      return;
    }
    try {
      Hashtable env = new Hashtable();
      env.put(Context.INITIAL_CONTEXT_FACTORY,
              "weblogic.jndi.WLInitialContextFactory");
      env.put(Context.PROVIDER_URL,          arg[0]);
      env.put(Context.SECURITY_PRINCIPAL,    arg[1]);
      env.put(Context.SECURITY_CREDENTIALS,  arg[2]);

      ctx = new InitialContext(env);
      Frobable f = (Frobable) ctx.lookup("frobtarget");
      f.frob();
      System.out.println("Frobbed successfully");
    }
    catch (Throwable t) {
      t.printStackTrace();
      System.out.println("Failed to frob");
    }
    finally {
      try {ctx.close();}
      catch (Exception e) {
        // Deal with any failures
      }
    }
  }
}
