/**
 * SampleAction.java
 *
 * JAAS sample PrivilegedAction Implementation
 *
 * @author Copyright (c) 2000-2001 by BEA Systems, Inc. All Rights Reserved.
 */

package examples.security.jaas;

/**
 * @exclude
 *
 */

import java.security.PrivilegedAction;
import javax.naming.Context;
import javax.naming.InitialContext;
import java.util.Hashtable;

public class SampleAction implements PrivilegedAction
{
  public Object run()
  {
    Object obj = null;
    Context ctx = null;
    String url = null;

    try
    {
      // Retrieve WLS server URL string
      url = System.getProperty("weblogic.security.jaas.ServerURL");
    }
    catch(NullPointerException npe)
    {
      System.err.println("Error: ServerURL Not Specified");
      return null;
    }
    catch(IllegalArgumentException iae)
    {
      System.err.println("Error: ServerURL Not Specified");
      return null;
    }
    catch(SecurityException se)
    {
      System.err.println("Error: Security Exception on accessing ServerURL Specification");
      return null;
    }

    // Populate environment
    Hashtable env = new Hashtable();
    env.put(Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory");
    env.put(Context.PROVIDER_URL, url);

    try
    {
      // Create InitialContext
      ctx = new InitialContext(env);

      // Lookup target EJB
      examples.security.jaas.Frobable f = (examples.security.jaas.Frobable) ctx.lookup("frobtarget");

      // Execute target EJB Frobable.frob() method
      f.frob();
      System.out.println("Frobbed successfully");
    }
    catch(Throwable t)
    {
      t.printStackTrace();
      System.out.println("Failed to frob");
    }
    finally
    {
      try
      {
        // Close InitialContext
        ctx.close();
      }
      catch(Exception e)
      {
        // Deal with any failures
      }
    }
    return obj;
  }
}

