package examples.security.net;


import java.net.InetAddress;


/**
 * Fast filter rule.
 *
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
class FastFilterEntry
  extends FilterEntry
{
  private int addrMask;
  private int netMask;

  FastFilterEntry(boolean action, int protomask, int address, int netmask)
  {
    super(action, protomask);
    addrMask = address & netmask;
    netMask = netmask;
  }
    
  protected boolean match(InetAddress addr)
  {
    return (SimpleConnectionFilter.addressToInt(addr) & netMask) == addrMask;
  }
}


