package examples.security.rdbmsrealm;


import weblogic.utils.NestedRuntimeException;


/**
 * This exception is thrown if an error occurs in the RDBMS realm
 * code.  It is an unchecked exception because the underlying realm
 * interfaces do not provide for checked exceptions to indicate
 * errors.
 *
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class RDBMSException
  extends NestedRuntimeException
{
  /**
   * Construct an exception with no detail message and no nested
   * Throwable.
   */
  public RDBMSException()
  {
    super();
  }

  /**
   * Construct an exception with the given detail message and no
   * nested Throwable.
   *
   * @param msg detail message
   */
  public RDBMSException(String msg)
  {
    super(msg);
  }

  /**
   * Construct an exception with no detail message and the given
   * nested Throwable.
   *
   * @param nested nested Throwable
   */
  public RDBMSException(Throwable nested)
  {
    super(nested);
  }

  /**
   * Construct an exception with the given detail message and nested
   * Throwable.
   *
   * @param msg detail message
   * @param nested nested Throwable
   */
  public RDBMSException(String msg, Throwable nested)
  {
    super(msg, nested);
  }
}
