package examples.security.sslclient;

import weblogic.security.X509;
import java.net.InetAddress;

/**
 * HostnameVerifier provides a callback mechanism so that implementers 
 * of this interface can supply a policy for handling the case where
 * the host that's being connected to and the server name from the
 * certificate SubjectDN must match.
 *
 * <p>
 * This is a null version of that class to show the WebLogic SSL client
 * classes without major problems. For example, in this case, the client
 * code connects to a server at 'localhost' but the democertificate's
 * SubjectDN CommonName is 'bea.com' and the default WebLogic
 * HostnameVerifier does a String.equals() on those two hostnames.
 *
 * @see HostnameVerifier#verify
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class NulledHostnameVerifier implements weblogic.security.SSL.HostnameVerifier {

  public boolean verify(String urlHostname, String certHostname) {
    return true;
  }

  public boolean verify(InetAddress addr, X509 cert) {
    return true;
  }

}
