package examples.security.sslclient;

import weblogic.security.SSL.TrustManager;
import weblogic.security.X509;

/**
 * Given the partial or complete certificate chain provided by
 * the peer, build a certificate path to a trusted root and return
 * true if it can be validated and is trusted for client SSL 
 * authentication.
 *
 * This is a null implemention which always returns true after
 * printing the certificate chain to System.out
 *
 * This is an example only and should NOT be used in a
 * production environment.
 */

public class NulledTrustManager implements TrustManager{

  

  public boolean certificateCallback(X509[] o, int validateErr) {
    System.out.println(" --- Do Not Use In Production ---\n" + "  By using this " + 
                       "NulledTrustManager, the trust in the server's identity "+
                       "is completely lost.\n --------------------------------");
    for (int i=0; i<o.length; i++)
      System.out.println(" certificate " + i + " -- " + o[i].toString());
    return true;
  }

}
