package examples.servlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;


/**
 * This simple servlet sends back an HTTP
 * error response. The type of HTTP error response is based on the
 * HTTP error code number that is passed as a query string.
 *
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up your development shell as described in 
 * <a href=../examples.html#environment>Setting up your environment</a>.
 * <p>
 * <li>Compile the servlet using the following command line:
 * <pre>  $ <b>javac -d %EX_WEBAPP_CLASSES% ErrorServlet.java</b></pre>
 *  
 * <p> <li>Start WebLogic Server with the <a
 * href=../examples.html>examples configuration</a>.  <p> 
 *
 *
 * </ol>
 * <p><h3>Configure the Server</h3>
 * <dl>
 * <dd>Make sure that the <b>examplesWebApp</b> is <a href=../examples.html#webApp>deployed on your server</a>.
 * </dl>
 * <p><h3>Run the example</h3>
 * <dl>
 * <dd>Use a web browser to load  the following URL: 
 * 
 * <pre><b>http://localhost:7001/examplesWebApp/ErrorServlet?code=<i>XXX</i></b></pre>
 * Where <i>XXX</i> is a valid HTTP error code. 
 * </dl>
 * <h3>Notes</h3>
 * If you do not include the <font face="Courier New" size=-1>?code=<i>XXX</i></font> portion of the URL, this example will display a message asking you to do so. 
 * <h3>There's More...</h3>
 *
 * For more information on servlets, see  <a
 * href="http://e-docs.bea.com/wls/docs61/servlet/index.html">Programming WebLogic HTTP Servlets</a>. 
 * <p>
 * @author Copyright (c) 1996-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved. 
 */



public class ErrorServlet extends HttpServlet {
  
  public ErrorServlet() {}

  /**
   * Implements the servlet service method.
   */
  public void service(HttpServletRequest req, HttpServletResponse res)
       throws ServletException, IOException
  {
    
    // if the user does not include a "code" paramater in the url, they will see this message:
    String scode = null;
    if (req.getParameter("code") != null)
      scode = req.getParameter("code");
    if (scode == null) {
        // use the response object to get a PrintWriter object
        PrintWriter out = res.getWriter();
        String title = "ErrorServlet";
        // use the PrintWriter object to create the HTML page header
        out.println("<HTML><HEAD><TITLE>");
        out.println(title);
        out.println("</TITLE></HEAD><BODY>");
        out.println("<p><img src=images/BEA_Button_Final_web.gif align=right>");
        out.println("<H1>" + title + "</H1>");
        out.println("</BODY></HTML>");
        out.println("Add a code to your URL like this:" + 
                    "<p><pre> http://WebLogicURL:port/error?code=404</pre>");
        out.println("</body></html>");
      return;
    }
    
    //    ServletOutputStream out = res.getOutputStream();
    int code = Integer.parseInt(req.getParameter("code"));
    res.sendError(code);
  }
  
}
