package examples.servlets;

import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * 
 * The PhoneServlet example demonstrates processing data received from
 * a form and reading data from a text file.
 *
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../examples.html#environment>Setting up Your Environment for 
 * Building and Running the Examples</a>.
 * <p>
 * <li>Compile the servlet using the following command line:
 * <pre>  $ <b>javac -d %EX_WEBAPP_CLASSES% PhoneServlet.java</b></pre>
 *
 * <li>Copy the file <font face = "Courier New"
 * size=-1>PhoneServletExample.html</font>, located in the <font face = "Courier New" size=-1>samples/examples/servlets</font> directory in your
 * WebLogic Server installation, to the <font face = "Courier New"
 * size=-1>config/examples/applications/examplesWebApp</font>
 * directory in your WebLogic Server installation. 
 * This directory is the location of the publicly-available files of the examplesWebApp.
 * 
 * <p> <li>Start WebLogic Server with the <a
 * href=../examples.html>examples configuration</a>.  <p> 
 *
 * </ol>
 * <p><h3>Configure the Server</h3>
 * <dl>
 * <dd>Make sure that the <font face="Courier New" size=-1>examplesWebApp</font> is <a href=../examples.html#webApp>deployed on your server</a>.
 * </dl>
 * <p><h3>Run the Example</h3>
 * <dl>
 * <dd>Use a web browser to load the following URL: 
 * 
 * <pre><b>http://localhost:7001/examplesWebApp/PhoneServletExample.html</b></pre>
 *
 * </dl>
 * <h3>Notes</h3>
 * This example makes entries to the WebLogic Server log file as the
 * servlets executes. The location and name of your WebLogic Server
 * log file is defined in the WebLogic Server Administration Console.

 *<p>This example uses a text file called <font face="Courier New" size=-1>phonelist</font>, located in your WebLogic Server installation, in the <font face="Courier New" size=-1>samples/examples/servlets</font> directory. This file contains the phone number data. This is the file's contents:<pre>#
# phone list
#
John   x5555
Paul   x9999
George x8888
Ringo  x5556
</pre>
 * <h3>There's More...</h3>
 *
 * For more information on servlets, see  <a
 * href="http://e-docs.bea.com/wls/docs61/servlet/index.html">Programming WebLogic HTTP Servlets</a>. 
 * <p>
 * @author Copyright (c) 1996-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
*/

public class PhoneServlet extends HttpServlet { 
    private Properties phones;
  
    public void init(ServletConfig config) throws ServletException {
        int next;
        String name, number;
        
        super.init(config);
        
        log("PhoneServlet.initialize: enter");
        
        // look for the initialization parameter containing the file name
        // with the phone number list
        String fileName = getInitParameter("phonelist");
        if (fileName == null) {
            log("PhoneServlet.init: phonelist parameter not defined");
            return;
        }
        
        log("PhoneServlet.initialize: filename = " + fileName);
        
        // use the file name obtained from the initialization parameter 
        // to create a FileInputStream
        phones = new Properties();
        FileInputStream fin;
        try {
            fin = new FileInputStream(fileName);
            phones.load(fin);
        }
        catch (IOException e) {
            log("Phone servlet file not found. " + e);
            phones = null;
            throw new ServletException
                ("PhoneServlet failed to find phonelist file: " + fileName, e);
        }
    }
    
    /**
     * Implements the service method.  If the query is for a specific
     * person, this method returns their number; otherwise, it outputs 
     * the entire extensions list. An htmlKona servlet page is used to display
     * the results.
     */
    public void service(HttpServletRequest req, HttpServletResponse res)
        throws IOException
    {
        String userAgent = req.getHeader("User-agent");

        boolean isHTML = -1 != userAgent.indexOf("Windows");

        PrintWriter out;
        String title = "Phone Servlet";

        // Requesting userAgent can handle HTML (like Windows)
        if (isHTML) {
          // use the response object to set the content type
          res.setContentType("text/html");

          // use the response object to get a PrintWriter object
          out = res.getWriter();

          // use the PrintWriter object to create the HTML page header
          out.println("<HTML><HEAD><TITLE>");
          out.println(title);
          out.println("</TITLE></HEAD><BODY>");
          out.println("<p><img src=images/BEA_Button_Final_web.gif align=right>");
          out.println("<H1>" + title + "</H1>");
          out.println("</BODY></HTML>");
          out.println("<h2>Phone List</h2>");
        
          if (phones == null) {
              out.println("<b>Sorry, No phone list.</b>");
          }
          else {
              // The req object contains the HttpRequest parameters
              // This servlet checks for a parameter called 'name'
              String name = req.getParameter("name");
            
              if ((name != null) && (!name.equals(""))) {
                  // Try to return the phone number for the specified 'name' parameter
                  String phone = (String) phones.get(name);
                  if (phone == null) {
                      phone = name + " was Not found";
                  }
                  else {
                      phone = name + ": " + phone;
                  }
                  out.println(phone);
                  //        sp.getBody().addElement(new StringElement(phone));
              }
              else {
                  // List the entire phone directory using the 
                  // an HTML Table 
                  out.println("<table border=1>");

                  // create an Enumeration from the phones Properties object, 
                  // use the name parameter to look up the phone number
                  Enumeration e = phones.propertyNames();
                  while  (e.hasMoreElements()) {
                      String lookupname=(String) e.nextElement();
                      String phonenumber=phones.getProperty(lookupname,"not found");
                      out.println("<tr><td><b>" + lookupname + "</b></td><td>" +
                                  phonenumber + "</td></tr>");
                  }
                  out.println("</table>");
              }
              out.println("</body></html>");
          }

        } // of html
        // Requesting userAgent defaults to handle WML
        else {

          res.setContentType("text/vnd.wap.wml");

          // use the response object to get a PrintWriter object
          out = res.getWriter();

          // use the PrintWriter object to create the WML page header
          out.println("<?xml version=\"1.0\"?>");
          out.println("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \" http://www.wapforum.org/DTD/wml_1.1.xml\">");
          out.println("<wml>");
          out.println("<card title=\""+title+"\">");
          out.println("<p>Phone List</p>");

          if (phones == null) {
              out.println("<p>Sorry, No phone list.</p>");
          }
          else {
              // The req object contains the HttpRequest parameters
              // This servlet checks for a parameter called 'name'
              String name = req.getParameter("name");

              if ((name != null) && (!name.equals(""))) {
                  // Try to return the phone number for the specified 'name' parameter
                  String phone = (String) phones.get(name);
                  if (phone == null) {
                    phone = name + " was Not found";
                  }
                  else {
                      phone = name + ": " + phone;
                  }
                  out.println("<p>"+phone+"</p>");
              }
              else {
                  // List the entire phone directory using the WML Table
                  out.println("<p>");
                  out.println("<table columns=\"2\">");

                  // create an Enumeration from the phones Properties object,
                  // use the name parameter to look up the phone number
                  Enumeration e = phones.propertyNames();
                  while  (e.hasMoreElements()) {
                      String lookupname=(String) e.nextElement();
                      String phonenumber=phones.getProperty(lookupname,"not found");
                      out.println("<tr><td><b>" + lookupname + "</b></td><td>" +
                                  phonenumber + "</td></tr>");
                  }
                  out.println("</table>");
                  out.println("</p>");
              }
              out.println("</card>");
              out.println("</wml>");
          }

      } // of wml
    }
    
}


