package examples.servlets;
/*
 * @(#)SessionServlet.java	1.21 97/05/22
 * 
 * Copyright (c) 1996-1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.0
 */


import java.io.*;
import java.util.Enumeration;

import javax.servlet.*;
import javax.servlet.http.*;

/**
 * 
 * This is a simple example of an HTTP servlet that uses the
 * HttpSession class to track the number of times that a client has
 * visited the servlet.  Using session tracking provides an
 * alternative method for tracking a client and storing client
 * specific data, when the client browser does not support
 * cookies. This is achieved by encoding a tracking id into the URLs
 * in the hyperlinks of the HTML pages that are returned to the
 * client.
 *
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../examples.html#environment>Setting up Your Environment for 
 * Building and Running the Examples</a>.
 * <p>
 * <li>Compile the servlet using the following command line:
 * <pre>  $ <b>javac -d %EX_WEBAPP_CLASSES% SessionServlet.java</b></pre>
 * 
 * 
 * <p> <li>Start WebLogic Server with the <a
 * href=../examples.html>examples configuration</a>.  <p> 
 *
 * </ol>
 * <p><h3>Configure the Server</h3>
 * <ol>
 * <li>Make sure that the <font face="Courier New" size=-1>examplesWebApp</font> is <a href=../examples.html#webApp>deployed on your server</a>.
 * 
 * <p><li>If you wish to test this example with cookies turned off in
 * your browser, make sure that session tracking via URLRewriting is
 * configured in your <font face="Courier New"
 * size=-1>examplesWebApp</font>. By default, URLRewriting is not
 * enabled.
 *
 * </ol>
 * <p><h3>Run the Example</h3>
 * <ol>
 * <li>Use a web browser to load the following URL: 
 * 
 * <pre><b>http://localhost:7001/examplesWebApp/SessionServlet</b></pre>
 * <p><li>If you disable cookies in your browser and then click on the
 * link in the example to ensure that URL rewriting is used, you can
 * see that the session IDs are now included in the URL address bar of
 * the browser.

 * </ol>
 * <h3>There's More...</h3>
 *
 * For more information on HTTP servlets, see  <a
 * href="http://e-docs.bea.com/wls/docs61/servlet/index.html">Programming WebLogic HTTP Servlets</a>. 
 * <p>
 * @author Copyright (c) 1996-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.  */


public class SessionServlet extends HttpServlet { 
  
  public void doGet (HttpServletRequest req, HttpServletResponse res)
       throws ServletException, IOException
  {
    //Get the session object
    HttpSession session = req.getSession(true);
    
    // set content type and other response header fields first
    res.setContentType("text/html");
    
    // then write the data of the response
    PrintWriter out = res.getWriter();
    
    out.println("<HEAD><TITLE> " + "SessionServlet Output " +
                "</TITLE></HEAD><BODY>");
    out.println("<p><img src=images/BEA_Button_Final_web.gif align=right>");
    out.println("<h1> SessionServlet Output </h1>");
    
    // Retrieve the count value from the session
    Integer ival = (Integer) session.getAttribute("sessiontest.counter");
    
    if (ival==null) 
      ival = new Integer(1);
    else 
      ival = new Integer(ival.intValue() + 1);
    
    session.setAttribute("sessiontest.counter", ival);
    
    out.println("You have hit this page <b>" + ival + "</b> times.<p>");
    // when the user clicks on the link in the next line, the SessionServlet is called again, 
    // but now URL rewriting is turned on
    out.println("Click <a href=" + res.encodeURL("SessionServlet") +
                ">here</a>");
    out.println(" to ensure that session tracking is working even " +
                "if cookies aren't supported.<br>");
    out.println("Note that by default URL rewriting is not enabled " +
                "because of its expensive overhead");
    out.println("<p>");
    
    out.println("<h3>Request and Session Data:</h3>");
    out.println("Session ID in Request: " +
                req.getRequestedSessionId());
    out.println("<br>Session ID in Request from Cookie: " +
                req.isRequestedSessionIdFromCookie());
    out.println("<br>Session ID in Request from URL: " +
                req.isRequestedSessionIdFromURL());
    out.println("<br>Valid Session ID: " +
                req.isRequestedSessionIdValid());
    out.println("<h3>Session Data:</h3>");
    out.println("New Session: " + session.isNew());
    out.println("<br>Session ID: " + session.getId());
    out.println("<br>Creation Time: " + session.getCreationTime());
    out.println("<br>Last Accessed Time: " +
                session.getLastAccessedTime());
    
    out.println("</BODY>");
  }
  
}
