package examples.servlets;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import weblogic.html.*;

/**
 * 
 * This example demonstrates using HTML forms in servlets and using
 * htmlKona tables to display the output.
 *
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../examples.html#environment>Setting up Your Environment for 
 * Building and Running the Examples</a>.
 * <p>
 * <li>Compile the servlet using the following command line:
 * <pre>  $ <b>javac -d %EX_WEBAPP_CLASSES% SimpleFormServlet.java</b></pre>
 * 
 * 
 * <p> <li>Start WebLogic Server with the <a
 * href=../examples.html>examples configuration</a>.  <p> 
 *
 * </ol>
 * <p><h3>Configure the Server</h3>
 * <dl>
 * <dd>Make sure that the <font face="Courier New" size=-1>examplesWebApp</font> is <a href=../examples.html#webApp>deployed on your server</a>.
 * </dl>
 * <p><h3>Run the Example</h3>
 * <dl>
 * <dd>Use a web browser to load the following URL: 
 * 
 * <pre><b>http://localhost:7001/examplesWebApp/SimpleFormServlet</b></pre>
 *
 * </dl>
 * <h3>There's More...</h3>
 *
 * For more information on servlets, see  <a
 * href="http://e-docs.bea.com/wls/docs61/servlet/index.html">Programming WebLogic HTTP Servlets</a>. 
 * <p>
 * @author Copyright (c) 1996-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.  
 */

public class SimpleFormServlet extends HttpServlet{ 
  
  ServletPage sp;
  
  // Set up some arrays to make passing information easier.
  final static int B_EMAIL    = 0;
  final static int B_NAME     = 1;
  final static int B_COMPANY  = 2;
  final static int B_STREET   = 3;
  final static int B_CITY     = 4;
  final static int B_STATE    = 5;
  final static int B_ZIPCODE  = 6;
  final static int B_COUNTRY  = 7;
  final static int B_PHONE    = 8;
  final static int B_MAX      = 9;
  
  static String label[]  = new String[B_MAX];
  static {
    label[B_EMAIL]   = "Email";
    label[B_NAME]    = "Name";
    label[B_COMPANY] = "Company";
    label[B_STREET]  = "Street";
    label[B_CITY]    = "City";
    label[B_STATE]   = "State";
    label[B_ZIPCODE] = "Zipcode";
    label[B_COUNTRY] = "Country";
    label[B_PHONE]   = "Phone";
  }
  
  String value[] = new String[B_MAX];
  static int maxlens[]  = new int[B_MAX];
  static {
    maxlens[B_EMAIL]   = 40;
    maxlens[B_NAME]    = 30;
    maxlens[B_COMPANY] = 30;
    maxlens[B_STREET]  = 50;
    maxlens[B_CITY]    = 30;
    maxlens[B_STATE]   = 10;
    maxlens[B_ZIPCODE] = 10;
    maxlens[B_COUNTRY] = 15;
    maxlens[B_PHONE]   = 15;
  }
  
  /**
   * Generates an htmlKona FormElement with the form fields already added
   */
  private static FormElement getForm(String[] label, String[] value, int[] maxlens) {
    
    TableElement tab = new TableElement();
    for (int i = 0; i < B_MAX; i++) {
      tab.addElement(new TableRowElement()
                     .addElement(new BoldElement(label[i]) + ":")
                     .addElement(new InputElement(label[i])
                                 .setSize(30)
                                 .setMaxlen(maxlens[i])
                                 .setValue(value[i])));
    }
    
    tab.addElement(new TableRowElement()
                   .addElement(new TableDataElement(new InputElement("SUBMIT",
                                                                     FieldType.submit)
                                                    .setValue("Register"))
                               .setColSpan(2)
                               .setAlign(AlignType.center)));
    
    FormElement form = new FormElement("SimpleFormServlet", "POST");
    form.addElement(tab);
    return form;
  }
  
  /**
   * The doGet method handles the initial invokation of the servlet. It responds 
   * with a form, that will use the "POST" method to submit data. 
   */
  public void doGet(HttpServletRequest req, HttpServletResponse res)
       throws IOException, ServletException
  {
    try {
      res.setContentType("text/html");
      res.setHeader("Pragma", "no-cache");
      
      ServletPage sp = new ServletPage();
      sp = new ServletPage();
      
      FormElement fe = getForm(label, value, maxlens);
      sp.getBody()
           .addElement(fe.asCenteredElement())
           .addElement(MarkupElement.HorizontalLine);
      
      sp.output(res.getOutputStream());
    }
    catch (Throwable th) {
      ByteArrayOutputStream buf = new ByteArrayOutputStream();
      try {
        PrintWriter ps = new PrintWriter(buf);
        th.printStackTrace(ps);
        ps.flush();
      }
      catch (Exception e) {}
    }
  }
  
  /**
   * Responds to the "POST" query from the original form supplied by the goGet() 
   * method. 
   */
  public void doPost(HttpServletRequest req, HttpServletResponse res)
       throws IOException, ServletException
  {
    res.setContentType("text/html");
    res.setHeader("Pragma", "no-cache");
    PrintWriter pw = new PrintWriter(res.getOutputStream(),true);
    pw.println("<HTML><HEAD><TITLE>Thank you!</TITLE></HEAD>");
    pw.println("<BODY>");
    pw.println("<p><img src=images/BEA_Button_Final_web.gif align=right>");
    pw.println("Thank you for filling out our form. The information you have submitted is as follows:");
    pw.println("<P>");
    pw.println("<P>");
    String ParamString;
    Enumeration ParamNames = req.getParameterNames();
    while(ParamNames.hasMoreElements()){
      ParamString = (String)ParamNames.nextElement();
      if (!ParamString.equals("SUBMIT")) {
        pw.println("<b>" + ParamString + ":</b> " + 
                   req.getParameterValues(ParamString)[0]);
        pw.println("<P>");
      }
    }
    pw.println("</BODY></HTML>");
    return;
  }
  
}

