package examples.servlets;
/*
 * @(#)SnoopServlet.java	1.20 97/11/17
 * 
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.0
 */

import java.io.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;


/**
 *
 * This servlet demonstrates getting and using the request
 * information, headers, and parameters sent by the browser.
 * 
 *
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../examples.html#environment>Setting up Your Environment for 
 * Building and Running the Examples</a>.
 * <p>
 * <li>Compile the servlet using the following command line:
 * <pre>  $ <b>javac -d %EX_WEBAPP_CLASSES% SnoopServlet.java</b></pre>
 * 
 * 
 * <p> <li>Start WebLogic Server with the <a
 * href=../examples.html>examples configuration</a>.  <p> 
 *
 * </ol>
 * <p><h3>Configure the Server</h3>
 * <dl>
 * <dd>Make sure that the <font face="Courier New"
 * size=-1>examplesWebApp</font> is <a
 * href=../examples.html#webApp>deployed on your server</a>.
 * </dl>
 * <p><h3>Run the Example</h3>
 * <ol>
 * <li>Use a web browser to load the following URL: 
 * 
 * <pre><b>http://localhost:7001/examplesWebApp/SnoopServlet</b></pre>
 *
 * <p><li>If you add some request parameters to the URL the servlet
 * will read those parameters form the request and display them in the
 * output. For example:
 *
 * <pre><b>http://localhost:7001/examplesWebApp/SnoopServlet?testParam=somevalue</b></pre>
 *
 * </ol>
 * <h3>There's More...</h3>
 *
 * For more information on servlets, see  <a
 * href="http://e-docs.bea.com/wls/docs61/servlet/index.html">Programming WebLogic HTTP Servlets</a>. 
 * <p>
 * @author Copyright (c) 1996-98 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.  */


public class SnoopServlet extends HttpServlet {
  
  public void service(HttpServletRequest req, HttpServletResponse res)
       throws ServletException, IOException
  {
    res.setContentType("text/html");
    PrintWriter	out = res.getWriter();
    
    out.println("<html>");
    out.println("<head><title>Snoop Servlet</title></head>");
    out.println("<body>");
    out.println("<p><img src=images/BEA_Button_Final_web.gif align=right>");
    out.println("<h1>Requested URL:</h1>");
    out.println("<pre>");
    out.println(HttpUtils.getRequestURL(req).toString());
    out.println("</pre>");
    
    Enumeration enum = getServletConfig().getInitParameterNames();
    if (enum != null) {
      boolean first = true;
      while (enum.hasMoreElements()) {
        if (first) {
          out.println("<h1>Init Parameters</h1>");
          out.println("<pre>");
          first = false;
        }
        String param = (String) enum.nextElement();
        out.println(" "+param+": "+getInitParameter(param));
      }
      out.println("</pre>");
    }
    
    out.println("<h1>Request information:</h1>");
    out.println("<pre>");
    
    print(out, "Request method", req.getMethod());
    print(out, "Request URI", req.getRequestURI());
    print(out, "Request protocol", req.getProtocol());
    print(out, "Servlet path",     req.getServletPath());
    print(out, "Path info",        req.getPathInfo());
    print(out, "Path translated",  req.getPathTranslated());
    print(out, "Query string",     req.getQueryString());
    print(out, "Content length",   req.getContentLength());
    print(out, "Content type",     req.getContentType());
    print(out, "Server name",      req.getServerName());
    print(out, "Server port",      req.getServerPort());
    print(out, "Remote user",      req.getRemoteUser());
    print(out, "Remote address",   req.getRemoteAddr());
    print(out, "Remote host",      req.getRemoteHost());
    print(out, "Scheme",           req.getScheme());
    print(out, "Authorization scheme", req.getAuthType());
    print(out, "Request scheme", req.getScheme());
    out.println("</pre>");

    out.println("<h1>Certificate Information</h1>");
    try {
      weblogic.security.X509 certs [] = (weblogic.security.X509 [])
	req.getAttribute("javax.net.ssl.peer_certificates");

      if (certs != null) {
        weblogic.security.JDK11Certificate jdk11cert = new weblogic.security.JDK11Certificate(certs[0]);
        out.print("<h2>WebLogic Certificate Objects</h2>");
        out.println("<pre>");
        print(out, "Subject Name", jdk11cert.getPrincipal().getName() );
        print(out, "Issuer Name", jdk11cert.getGuarantor().getName() );
        print(out, "Certificate Chain Length", certs.length);
        for (int i=0; i<certs.length;i++)
	  print(out,"Certificate["+i+"]",certs[i].toString());
        out.println("</pre>");

	//sun.security.x509.X509Cert sunCert = new sun.security.x509.X509Cert( certs[0].getBytes() );
	//print(out, "X509Cert",sunCert.toString());

        out.print("<h2>Java Security Objects</h2>");
        out.println("<pre>");
        java.security.cert.X509Certificate javaCerts [] = (java.security.cert.X509Certificate [])
          req.getAttribute("javax.servlet.request.X509Certificate");
        if (javaCerts != null) {
          print(out, "Subject Name", javaCerts[0].getSubjectDN().getName() );
          print(out, "Issuer Name", javaCerts[0].getIssuerDN().getName() );
          print(out, "Certificate Chain Length", javaCerts.length);
          for (int i=0; i<javaCerts.length; i++) {
            print(out,"Certificate["+i+"] Subject", javaCerts[i].getSubjectDN().getName());
            print(out,"Certificate["+i+"] Issuer", javaCerts[i].getIssuerDN().getName());
          }
        } else {
          out.print("No Java Certificate Objects Found.");
        }
        
        Integer keysize = (Integer) req.getAttribute("javax.servlet.request.key-size");
        if (keysize != null)
          print(out, "Key Size", keysize.toString());
        else
          print(out, "Key Size", "none found");
        String suite = (String) req.getAttribute("javax.servlet.request.cipher-suite");
        if (suite != null)
          print(out, "CipherSuite", suite.toString());
        else
          print(out, "CipherSuite", "none found");
        out.println("</pre>");

      } else {
	out.println("Not using SSL or client certificate not required for this connection.");
      }

    }catch (ClassCastException cce){System.out.println(cce.getMessage());cce.printStackTrace();}
    out.println("</pre>");

    Enumeration e = req.getHeaderNames();
    if (e.hasMoreElements()) {
      out.println("<h1>Request headers:</h1>");
      out.println("<pre>");
      while (e.hasMoreElements()) {
        String name = (String)e.nextElement();
        out.println(" " + name + ": " + req.getHeader(name));
      }
      out.println("</pre>");
    }
    
    e = req.getParameterNames();
    if (e.hasMoreElements()) {
      out.println("<h1>Servlet parameters (Single Value style):</h1>");
      out.println("<pre>");
      while (e.hasMoreElements()) {
        String name = (String)e.nextElement();
        out.println(" " + name + " = " + req.getParameter(name));
      }
      out.println("</pre>");
    }
    
    e = req.getParameterNames();
    if (e.hasMoreElements()) {
      out.println("<h1>Servlet parameters (Multiple Value style):</h1>");
      out.println("<pre>");
      while (e.hasMoreElements()) {
        String name = (String)e.nextElement();
        String vals[] = (String []) req.getParameterValues(name);
        if (vals != null) {
          out.print("<b> " + name + " = </b>"); 
          out.println(vals[0]);
          for (int i = 1; i<vals.length; i++)
            out.println("           " + vals[i]);
        }
        out.println("<p>");
      }
      out.println("</pre>");
    }

    out.println("<h1>Request Attributes:</h1>");
    e = req.getAttributeNames();
    if (e.hasMoreElements()) {
      out.println("<pre>");
      while (e.hasMoreElements()) {
        String name = (String)e.nextElement();
	Object o = req.getAttribute(name);
	if (o == null) continue;
        out.println(" " + name + ": type=" + o.getClass().getName() + " str='" + o.toString() + "'");
      }
      out.println("</pre>");
    }
    out.println("</body></html>");
  }
  
  private void print (PrintWriter out, String name, String value)
  {
    out.print(" " + name + ": ");
    out.println(value == null ? "&lt;none&gt;" : value);
  }
  
  private void print (PrintWriter out, String name, int value)
  {
    out.print(" " + name + ": ");
    if (value == -1) {
      out.println("&lt;none&gt;");
    } else {
      out.println(value);
    }
  }
}
