package examples.servlets;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/*
 * @(#)SurveyServlet.java
 *
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */


/**
 * This example servlet takes input from a form and writes it out to a simple
 * text file. 
 * <p><b>Note:</b> This servlet has been modified from the SurveyServlet that is
 * distributed with the JSDK2.0 so that it does not implement the
 * SingleThreadModel.  <p>The Survey servlet uses an initialization
 * parameter to define the location of the text file containing the
 * survey results.
 * Initialization parameters are defined in the <font
 * face="Courier New" size=-1>web.xml</font> file that defines a Web
 * Application, in this case the <font face="Courier New"
 * size=-1>examplesWebApp</font>. The <font face="Courier New"
 * size=-1>web.xml</font> file is located in your WebLogic Server
 * distribution at <font face="Courier New"
 * size=-1>config/examples/applications/examplesWebApp/WEB-INF/web.xml</font>.  
 * 
 * <p><h3>Build the Example</h3> <ol>
 * <li> Open a new command shell.  
 *
 * <p><li>Set up this development shell as described in <a
 * href=../examples.html#environment>Setting up Your Environment for
 * Building and Running the Examples</a>. 
 *
 * <p> <li>Compile the servlet
 * using the following command line: <pre> $ <b>javac -d %EX_WEBAPP_CLASSES% SurveyServlet.java</b></pre>
 * 
 * 
 * <p> <li>Start WebLogic Server with the <a
 * href=../examples.html>examples configuration</a>. 
 * <p> 
 * <li>Copy the file <font face = "Courier New"
 * size=-1>SurveyExample.html</font>, located in the <font face
 * = "Courier New" size=-1>samples/examples/servlets</font> directory
 * in your WebLogic Server installation, to the <font face = "Courier New" size=-1>config/examples/applications/examplesWebApp</font>
 * directory in your WebLogic Server installation.  This directory is
 * the location of the publicly-available files of the
 * examplesWebApp.
 *
 * </ol>
 * <p><h3>Configure the Server</h3>
 * <ol>
 * <li>Make sure that the <font face="Courier New" size=-1>examplesWebApp</font>
 * is <a href=../examples.html#webApp>deployed on your server</a>.
 *
 * <p><li>Make sure that the <font face="Courier New" size=-1>&lt;init-param&gt;resultsDir</font> is defined and points to a valid
 * directory. Make sure that the WebLogic Server has write permissions
 * to this directory. The <font face="Courier New" size=-1>&lt;init-param&gt;</font> is defined in the
 * deployment descriptor for the examplesWebApp, located at <font
 * face="Courier New"
 * size=-1>/config/examples/applications/examplesWebApp/WEB-INF/web.xml</font>
 * in your WebLogic Server distribution.  The <font face="Courier New" size=-1>&lt;servlet&gt;</font> element
 * registers the SurveyServlet. This attribute is set by default to
 * the <font face="Courier New" size=-1>samples/examples/servlets</font>
 * directory in your WebLogic Server distribution.
 *
 * </ol>
 * <p><h3>Run the Example</h3>
 * <dl>
 * <dd>Use a Web browser to load the following URL: 
 * 
 * <pre><b>http://localhost:7001/examplesWebApp/SurveyExample.html</b></pre>
 * <p>If the servlet executes correctly you will see a "Thank you for participating"
 * message in the browser and the results of the survey will be
 * written to a file called "Survey01Results.txt", located in the
 * <font face="Courier New" size=-1>samples/examples/servlets</font>
 * directory in your WebLogic Server distribution.
 * </dl>
 * 
 * @author Adapted from the JSDK2.0 by BEA Systems, Inc.
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved. 
 */

public class SurveyServlet extends HttpServlet 
{
  String resultsDir;
  
  public void init(ServletConfig config)
       throws ServletException
  {
    super.init(config);
    resultsDir = getInitParameter("resultsDir");
    if (resultsDir == null) {
      Enumeration initParams = getInitParameterNames();
      System.err.println("The init parameters were: ");
      while (initParams.hasMoreElements()) {
        System.err.println(initParams.nextElement());
      }
      System.err.println("Should have seen one parameter name");
      throw new UnavailableException (this,
                                      "Not given a directory to write survey results!");
    }
  }
  
  /**
   * Writes survey results to an output file in response to the POSTed
   * form.  Writes a "thank you" message to the client.     
   */
  public void doPost(HttpServletRequest req, HttpServletResponse res)
       throws ServletException, IOException
  {
    // first, set the "content type" header of the response
    res.setContentType("text/html");
    
    //Get the response's PrintWriter to return text to the client.
    PrintWriter toClient = res.getWriter();
    
    try {
      //Open the file for writing the survey results.
      String surveyName = req.getParameterValues("survey")[0];
      FileWriter resultsFile = new FileWriter(resultsDir
                                              + System.getProperty("file.separator")
                                              + surveyName + ".txt", true);
      PrintWriter toFile = new PrintWriter(resultsFile);
      
      // Get client's form data & append it to the file
      toFile.println("<BEGIN>");
      Enumeration values = req.getParameterNames();
      while(values.hasMoreElements()) {
        String name = (String)values.nextElement();
        String value = req.getParameterValues(name)[0];
        // Don't write the submit parameter
        if(name.compareTo("submit") != 0) {
          toFile.println(name + ": " + value);
        }
      }
      toFile.println("<END>");
      
      //Close the file.
      resultsFile.close();
      
      // Respond to client with a thank you
      toClient.println("<html>");
      toClient.println("<title>Thank you!</title>");
      toClient.println("<body bgcolor=#ffffff><p><img src=images/BEA_Button_Final_web.gif align=right>" +
		       "<font face=\"Helvetica\">" +
                       "Thank you for participating</font></body>");
      toClient.println("</html>");
      
    } catch(IOException e) {
      e.printStackTrace();
      toClient.println("A problem occured while recording your answers. " +
                       "Please try again.");
    }
    
  }
}










