package examples.tutorials.migration.banking;

import java.io.*;
import java.util.*;
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.rmi.PortableRemoteObject;

import weblogic.rmi.Naming;

/**
 * BankAppServlet is a servlet. This servlet illustrates:
 * <ul>
 * <li> Handling of requests from a JSP
 * <li> Redirection of control to a JSP
 * <li> Interaction with an EJB, namely the Account EJB
 * </ul>
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class BankAppServlet extends HttpServlet {
  RMILogger theLogger = null;

  /**
   * This method performs servlet initialization.  The RMI Logger stub
   * is retrieved by doing a looking for the RMILoggerServer.
   *
   * @param config               ServletConfig
   */
  public void init(ServletConfig config) throws ServletException {
    super.init(config);
    try {
      // This uses the more traditional RMI lookup, rather than
      // a JNDI lookup. Looking up via JNDI is preferred, though
      // this method is supported for consistency.
      theLogger = (RMILogger)Naming.lookup("rmi://localhost:7001/RMILoggerServer");
      System.out.println("Successfully connected to RMILoggerServer");
    }
    catch (Throwable t) {
      t.printStackTrace();
      System.exit(-1);
    }
  }

  /**
   * Implements doPost.  Exceptions will be placed in the HttpSession to be
   * handled by the error.jsp.  If that fails, a stack trace will be printed.
   *
   * @param request             HttpServletRequest
   * @param response            HttpServletResponse
   */
  public void doPost (HttpServletRequest request, HttpServletResponse response) {
    try {
      if(request.getMethod().equals("HEAD")) return;
      handleRequest(request,response);
    } catch(Exception e) {
      try {
        HttpSession aSession;
        aSession = (HttpSession)(request.getSession(true));
        aSession.setAttribute("theException", e);
        this.redirectRequest(request, response, BankConstants.ERROR_JSP);
      } catch (Exception e2) {
        e2.printStackTrace();
      }
    }
  }

  /**
   * Forward the request to another servlet or JSP
   *
   * @param request             HttpServletRequest
   * @param response            HttpServletResponse
   * @param filename            File to redirect to; can be a URL
   */
  public final void redirectRequest(HttpServletRequest request,HttpServletResponse response,String filename)
    throws ServletException, IOException {
    ServletContext ctx = getServletContext();
    RequestDispatcher rd;
    rd = ctx.getRequestDispatcher("/"+filename);
    rd.forward(request, response);
  }

  /**
   * Handle all requests from the client.
   *
   * @param request             HttpServletRequest
   * @param response            HttpServletResponse
   */
  public void handleRequest (HttpServletRequest request, HttpServletResponse response)
    throws Exception, ServletException, IOException, NamingException {

    Account anAccount = null;
    String accountID = "";
    String buttonClickedStr = request.getParameter("buttonClicked");
    HttpSession mySession = request.getSession();
    if (buttonClickedStr != null) {
      theLogger.log("Button Clicked = " + buttonClickedStr);
      if (buttonClickedStr.equals(BankConstants.BTN_DEPOSIT)) {
        anAccount = (Account)(mySession.getAttribute("myAccount"));
        theLogger.log("Deposit Amount = "
          + (String)request.getParameter("transactionAmount"));
        try {
          Double depositValue
            = new Double((String)request.getParameter("transactionAmount"));
          anAccount.deposit(depositValue.doubleValue());
        } catch (NumberFormatException e) {
          this.theLogger.log("Not a valid number");
          Exception anException = new Exception("Not a valid deposit amount");
          throw anException;
        }
      } else if (buttonClickedStr.equals(BankConstants.BTN_WITHDRAW)) {
        anAccount = (Account)(mySession.getAttribute("myAccount"));
        theLogger.log("Deposit Amount = "
          + (String)request.getParameter("transactionAmount"));
        try {
          Double withdrawValue
            = new Double((String)request.getParameter("transactionAmount"));
          anAccount.withdraw(withdrawValue.doubleValue());
        } catch (NumberFormatException e) {
          this.theLogger.log("Not a valid number");
          Exception anException
            = new Exception("Not a valid withdrawal amount");
          throw anException;
        }

      };
      mySession.setAttribute("myAccount", anAccount);
    } else {
      // if no button clicks are detected, then the request is an
      // account lookup attempt.
      accountID = (String)request.getParameter("accountID");
      mySession.setAttribute("currentAccountID", accountID);
      if (accountID != null) {
        anAccount = this.findAccount(accountID);
        if (anAccount != null) {
          mySession.setAttribute("myAccount", anAccount);
        } else {
          Exception anException = new Exception("Account Not Found");
          throw anException;
        }
      } else {
        System.out.println("Not a valid string");
        System.exit(1);
      }
    }
    this.redirectRequest(request, response, BankConstants.ACCOUNT_DETAIL_JSP);
  }

  /**
   * Find account with the passed in ID.
   *
   * @param id                  Account ID
   *
   * @return                    Account remote stub
   */
  private Account findAccount(String id)
    throws CreateException, FinderException, RemoteException, NamingException,
    weblogic.rmi.RemoteException {

    Account remote = null;
    AccountHome home = lookupHome();
    try {
      remote = (Account) PortableRemoteObject.narrow(home.findByPrimaryKey(id),
                                                                 Account.class);
    }catch (ObjectNotFoundException onfe) {
      theLogger.log("No Account found.");
    }
    return remote;
  }

  /**
   * Look up the bean's home interface using JNDI
   *
   * @return                    Account remote stub
   */
  private AccountHome lookupHome() throws weblogic.rmi.RemoteException,
    NamingException {

    Context ctx = getInitialContext();

    try {
      Object home = (AccountHome) ctx.lookup("containerManaged.AccountHome");
      return (AccountHome) PortableRemoteObject.narrow(home, AccountHome.class);

    } catch (NamingException ne) {
      StringBuffer aSB = new StringBuffer();
      aSB.append("The client was unable to lookup the EJBHome.  Please make ");
      aSB.append("sure that you have deployed the ejb with the JNDI name ");
      aSB.append("beanManaged.AccountHome on the WebLogic server");
      theLogger.log(aSB.toString());
      throw ne;
    }
  }

  /**
   * Get an initial context into the JNDI tree.
   *
   * Java2 clients can use the jndi.properties file to set the
   * INITIAL_CONTEXT_FACTORY and the PROVIDER_URL
   *  private Context getInitialContext() throws NamingException {
   *    return new InitialContext();
   *  }
   *
   *
   * Using a Properties object will work on JDK 1.1.x and Java2
   * clients
   */
  private Context getInitialContext() throws weblogic.rmi.RemoteException,
    NamingException {

    try {
      // Get an InitialContext
      Properties h = new Properties();
      h.put(Context.INITIAL_CONTEXT_FACTORY,
        "weblogic.jndi.WLInitialContextFactory");
      return new InitialContext(h);
    } catch (NamingException ne) {
      StringBuffer aSB = new StringBuffer();
      aSB.append("We were unable to get a connection to the WebLogic server");
      aSB.append("Please make sure that the server is running.");
      theLogger.log(aSB.toString());
      throw ne;
    }
  }
}