package examples.tutorials.migration.banking;

import weblogic.rmi.Naming;
import weblogic.rmi.RemoteException;
import weblogic.rmi.RMISecurityManager;
import weblogic.rmi.server.UnicastRemoteObject;

/**
 * With WebLogic RMI, you don't need to extend
 * UnicastRemoteObject.  Also, you don't need to set a
 * SecurityManager, although you can set one if desired. WebLogic RMI
 * uses security measures (like SSL) that are build into WebLogic,
 * rather than implementing a special case of security for remote
 * objects.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class RMILoggerImpl implements RMILogger
// This is unecessary in WebLogic RMI
// extends UnicastRemoteObject
{

  private String name;

  /**
   * Constructs a RMILoggerImpl with the specified string.
   *
   * @param s                 String message
   */
  public RMILoggerImpl(String s) throws RemoteException {
    super();
    name = s;
  }

  /**
   * Prefixes the string with RMILogger and outputs it.
   *
   * @param s                 String message.
   * @exception               weblogic.rmi.RemoteException
   */
  public void log(String s) throws RemoteException {
    System.out.println("RMILogger:" + s);
  }

  /**
   * Allows the WebLogic Server to instantiate this implementation
   * and bind it in the registry.
   */
  public static void main(String args[]) {
    // Creating and installing the security manager
    // is unnecessary with WebLogic RMI
    if (System.getSecurityManager() == null)
      System.setSecurityManager(new RMISecurityManager());

    try {
      RMILoggerImpl obj = new RMILoggerImpl("RMILoggerServer");
      Naming.rebind("RMILoggerServer", obj);
      System.out.println("RMILoggerImpl created and bound in the registry " +
                         "to the name RMILoggerServer");

    }
    catch (Exception e) {
      System.out.println("RMILoggerImpl.main: an exception occurred:");
      e.printStackTrace();
    }
  }
}

