#!/bin/sh

# Adjust these variables to match your environment
JAVA_HOME=${JAVA_HOME:-@JAVA_HOME}
WL_HOME=${WL_HOME:-@WL_HOME}
MYSERVER="$WL_HOME/migrationserver"
SERVER_CLASSES=${SERVER_CLASSES:-$WL_HOME"/serverclasses"}
SERVLET_CLASSES=${SERVLET_CLASSES:-$WL_HOME"/servletclasses"}
CLIENT_CLASSES=${CLIENT_CLASSES:-$WL_HOME"/clientclasses"}
MYCLASSPATH=$JAVA_HOME/lib/classes.zip:$WL_HOME/classes:$WL_HOME/lib/weblogicaux.jar:$CLIENT_CLASSES:$SERVER_CLASSES:$SERVLET_CLASSES

# Create the build directory, and copy the deployment descriptors into it
mkdir -p build build/META-INF
cp -f *.xml build/META-INF

# Compile ejb classes into the build directory (jar preparation)
$JAVA_HOME/bin/javac -d build -classpath $MYCLASSPATH Account.java AccountHome.java ProcessingErrorException.java AccountBean.java

# Make a standard ejb jar file, including XML deployment descriptors
(cd build; jar cv0f std_app_banking.jar META-INF examples; cd ..)

# Run ejbc to create the deployable jar file
$JAVA_HOME/bin/java -classpath $MYCLASSPATH \
   -Dweblogic.home=$WL_HOME weblogic.ejbc \
    -compiler javac build/std_app_banking.jar \
    $MYSERVER/app_banking.jar

# Compile ejb interfaces & client app into the clientclasses directory
$JAVA_HOME/bin/javac -classpath $MYCLASSPATH -d $SERVER_CLASSES Account.java AccountHome.java RMILogger.java RMILoggerImpl.java BankConstants.java ProcessingErrorException.java
$JAVA_HOME/bin/javac -classpath $MYCLASSPATH -d $SERVLET_CLASSES BankAppServlet.java
$JAVA_HOME/bin/javac -classpath $MYCLASSPATH -d $CLIENT_CLASSES Account.java AccountHome.java ProcessingErrorException.java Client.java
$JAVA_HOME/bin/java -classpath $MYCLASSPATH weblogic.rmic -d $SERVER_CLASSES examples.tutorials.migration.banking.RMILoggerImpl

