#! /usr/bin/sh
# This script should be used to set up your environment for
# compiling and running the examples included with WebLogic
# Server. It contains the following variables:
#
# WL_HOME   - This must point to the root directory of your WebLogic
#             installation.
# JAVA_HOME - Determines the version of Java used to compile
#             and run examples. This variable must point to the
#             root directory of a complete JDK installation. See
#             the WebLogic platform support page
#             (http://www.weblogic.com/docs51/platforms/index.html)
#             for an up-to-date list of supported JVMs on your platform.
#
# This script assumes that native libraries (performance packs and jDriver
# for Oracle) have been installed in the proper location and that your
# system PATH variable has been set appropriately (jDriver for Oracle only).
# For additional information refer to Installing and Setting up WebLogic
# Server (/install/index.html in your local documentation
# set or on the Internet at http://www.weblogic.com/docs51/install/index.html).
#
# Usage: ". setMigrationEnv.sh"
#
# Note: Change @WL_HOME and @JAVA_HOME to reflect your weblogic root
#       directory and java root directory, respectively.


# Set user-defined variables.
WL_HOME=${WL_HOME:-@WL_HOME}; export WL_HOME
JAVA_HOME=${JAVA_HOME:-@JAVA_HOME}; export JAVA_HOME

# Use .cmd script for Windows NT environment
if [ `uname -s` = "Windows_NT" ]
then
  echo "***Error*** Environment not set. Use setEnv.cmd if you are running Windows NT"
  exit
fi

#Report environment settings
reportenv() {
  echo "WL_HOME=$WL_HOME"
  echo "JAVA_HOME=$JAVA_HOME"
  echo "CLIENT_CLASSES=$CLIENT_CLASSES"
  echo "SERVER_CLASSES=$SERVER_CLASSES"
  echo "SERVLET_CLASSES=$SERVLET_CLASSES"
  echo "PATH=$PATH"
  echo "CLASSPATH=$CLASSPATH"
  case `uname -s` in
  AIX)
    if [ -n "$LIBPATH" ]; then
      LIBPATH=$LIBPATH:$WL_HOME/lib/aix
    else
      LIBPATH=$WL_HOME/lib/aix
    fi
    echo "LIBPATH=$LIBPATH"
  ;;
  HP-UX)
    if expr "`uname -r`" : "..11..." > /dev/null 2>&1; then
      hpsubdir=hpux11
    elif expr "`uname -r`" : "..10..." > /dev/null 2>&1; then
      hpsubdir=hpux10
    fi

    if [ -n "$SHLIB_PATH" ]; then
      SHLIB_PATH=$SHLIB_PATH:$WL_HOME/lib/$hpsubdir
    else
      SHLIB_PATH=$WL_HOME/lib/$hpsubdir
    fi
    echo "SHLIB_PATH=$SHLIB_PATH"

    chmod a+x `find $WL_HOME/lib/$hpsubdir -name "*.sl" -print`
;;
  IRIX)
    if [ -n "$LD_LIBRARY_PATH" ]; then
      LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/irix
    else
      LD_LIBRARY_PATH=$WL_HOME/lib/irix
    fi
    echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
  ;;
  LINUX|Linux)
    if [ -n "$LD_LIBRARY_PATH" ]; then
      LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/linux
    else
      LD_LIBRARY_PATH=$WL_HOME/lib/linux
    fi
    echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
  ;;
  OSF1)
    if [ -n "$_RLD_LIST" ]; then
      _RLD_LIST=$_RLD_LIST:$WL_HOME/lib/tru64unix
    else
      _RLD_LIST=$WL_HOME/lib/tru64unix
    fi
    echo "_RLD_LIST=$_RLD_LIST"
  ;;
  SunOS)
    if [ -n "$LD_LIBRARY_PATH" ]; then
      LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/solaris
    else
      LD_LIBRARY_PATH=$WL_HOME/lib/solaris
    fi
    echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
  ;;
  *)
    echo "$0: Don't know how to set the shared library path for `uname -s`.  "
  esac

  echo "=================================================="
  return 0
}

if [ -f ${JAVA_HOME}/bin/java ]; then
  PATH=$JAVA_HOME/bin:$PATH; export PATH
  export JAVA_HOME
  if [ -f ${WL_HOME}/setMigrationEnv.sh ]; then

    echo "============= Setting Environment ================"

    MIGRATION_SERVER=$WL_HOME/migrationserver
    CLIENT_CLASSES=$MIGRATION_SERVER/clientclasses; export CLIENT_CLASSES
    SERVER_CLASSES=$MIGRATION_SERVER/serverclasses; export SERVER_CLASSES
    SERVLET_CLASSES=$MIGRATION_SERVER/servletclasses; export SERVLET_CLASSES
    export WL_HOME

    # Check if we are running java 1
    if [ -f $JAVA_HOME/lib/classes.zip ]; then
      # Java 1
      CLASSPATH=$JAVA_HOME/lib/classes.zip:$WL_HOME/license:$WL_HOME/lib/weblogic510sp9.jar:$WL_HOME/classes:$WL_HOME/lib/weblogicaux.jar:$WL_HOME/eval/cloudscape/lib/cloudscape.jar:$CLIENT_CLASSES:$SERVER_CLASSES
      export CLASSPATH
      reportenv
    else
      # Java 2
      CLASSPATH=$JAVA_HOME/lib/tools.jar:$WL_HOME/license:$WL_HOME/lib/weblogic510sp9.jar:$WL_HOME/classes:$WL_HOME/lib/weblogicaux.jar:$WL_HOME/eval/cloudscape/lib/cloudscape.jar:$CLIENT_CLASSES:$SERVER_CLASSES
      export CLASSPATH
      reportenv
    fi
    unset reportenv

  else # WL_HOME
    echo ""
    echo "The WebLogic Server wasn't found in directory ${WL_HOME}."
    echo "Please edit the setMigration.sh script so that the WL_HOME"
    echo "variable refers to the WebLogic Server installation directory."
    echo ""
    echo "Environment not set."
  fi
  else # JAVA_HOME
    echo ""
    echo "The JDK wasn't found in directory ${JAVA_HOME}."
    echo "Please edit the setMigration.sh script so that the JAVA_HOME"
    echo "variable refers to the location of your JDK."
    echo ""
    echo "Environment not set."
  fi
