#!/bin/sh
# $Id$
#
# This script can be used to start WebLogic Server on UNIX systems.
# It contains following variables:
#
# JAVA_HOME      - Determines the version of Java used to start
#                  WebLogic Server. This variable must point to the
#                  root directory of a JDK or JRE installation. See
#                  the WebLogic platform support page
#                  (http://www.weblogic.com/docs51/platforms/index.html)
#                  for an up-to-date list of supported JVMs your platform.
# PRE_CLASSPATH  - Use this variable to prepend jar files or directories to
#                  the WEBLOGIC_CLASSPATH.
# POST_CLASSPATH - Use this variable to append jar files or directories to
#                  the end of the WEBLOGIC_CLASSPATH.
# JAVA_OPTIONS -   On some platforms, certain java command-line options are
#                  necessary when running WebLogic Server. For additional
#                  information, see Setting up and Starting WebLogic Server
#                  (/install/startserver.html in your local documentation set
#                  or on the Internet at
#                  http://www.weblogic.com/docs51/install/startserver.html)
#
# This script assumes that native libraries (performance packs and jDriver
# for Oracle) have been installed in the proper location and that your
# system PATH variable has been set appropriately (jDriver for Oracle only).
# For additional information refer to Installing and Setting up WebLogic
# Server (/install/index.html in your local documentation
# set or on the Internet at http://www.weblogic.com/docs51/install/index.html).

# Set user-defined variables
PRE_CLASSPATH=
POST_CLASSPATH=
JAVA_OPTIONS=

if [ `uname -s` = "Windows_NT" ]
then
  echo "***Error*** Use startMigration.cmd if you are running Windows NT"
  exit
fi

# Make sure we're in the right place
if [ ! -f license/WebLogicLicense.xml -o ! -f weblogic.policy ]; then
  echo "startMigration.sh: must be run from the WebLogic installation directory." 1>&2
  exit 1
else
  WL_HOME=`pwd`
fi

# Grab some file descriptors.
maxfiles=`ulimit -H -n`
if [ ! $? -a "$maxfiles" != 1024 ]; then
  if [ "$maxfiles" = "unlimited" ]; then
    maxfiles=1025
  fi
  if [ "$maxfiles" -lt 1024 ]; then
    ulimit -n $maxfiles
  else
    ulimit -n 1024
  fi
fi

# Set the server classpath
WEBLOGICCLASSPATH=./license:./lib/weblogic510sp9.jar:./classes:./lib/weblogicaux.jar:./migrationserver/serverclasses
if [ "$PRE_CLASSPATH" != "" ]; then
  WEBLOGICCLASSPATH=$PRE_CLASSPATH:$WEBLOGICCLASSPATH
fi

if [ "$POST_CLASSPATH" != "" ]; then
  WEBLOGICCLASSPATH=$WEBLOGICCLASSPATH:$POST_CLASSPATH
fi

# Find out which java version we're running

if [ -f $JAVA_HOME/lib/classes.zip ]; then
  # Java 1
  JAVACLASSPATH=$JAVA_HOME/lib/classes.zip:./lib/weblogic510sp9boot.jar:./classes/boot:./eval/cloudscape/lib/cloudscape.jar

  $JAVA -ms64m -mx64m -classpath $JAVACLASSPATH -Dweblogic.class.path=$WEBLOGICCLASSPATH -Dweblogic.home=. weblogic.Server
else
  # Java 2
  JAVACLASSPATH=./lib/weblogic510sp9boot.jar:./classes/boot:./eval/cloudscape/lib/cloudscape.jar

  $JAVA_HOME/bin/java $JAVA_OPTIONS -ms64m -mx64m -classpath $JAVACLASSPATH -Dweblogic.class.path=$WEBLOGICCLASSPATH -Dweblogic.home=. -Djava.security.manager -Djava.security.policy==$WL_HOME/weblogic.policy weblogic.Server
fi

