DROP TABLE ejbAccounts;
CREATE TABLE ejbAccounts (id varchar(15), bal float, type varchar(15));

DROP TABLE idGenerator;
CREATE TABLE idGenerator (tablename varchar(32), maxkey int);

DROP TABLE CUSTOMER;
CREATE TABLE customer(
   custid     int not null,
   name       varchar(30),
   address    varchar(30),
   city       varchar(30),
   state      varchar(2),
   zip        varchar(5),
   area       varchar(3),
   phone      varchar(8));

insert into customer values
   (100,'Jackson','100 First St.','Pleasantville','CA','95404','707','555-1234');
insert into customer values
   (101,'Elliott','Arbor Lane, #3','Centre Town','CA','96539','415','787-5467');
insert into customer values
   (102,'Avery','14 Main','Arthur','CA','97675','510','834-7476');

DROP TABLE emp;
CREATE TABLE emp (
   empno      int not null,
   ename      varchar(10),
   job        varchar(9),
   mgr        int,
   hiredate   date,
   sal        float,
   comm       float,
   deptno     int);

create unique index empno on emp(empno);

insert into emp values
   (7369,'SMITH','CLERK',7902,DATE'1980-12-17',800,NULL,20);
insert into emp values
   (7499,'ALLEN','SALESMAN',7698,DATE'1981-02-20',1600,300,30);
insert into emp values
   (7521,'WARD','SALESMAN',7698,DATE'1981-02-22',1250,500,30);
insert into emp values
   (7566,'JONES','MANAGER',7839,DATE'1981-04-02',2975,NULL,20);
insert into emp values
   (7654,'MARTIN','SALESMAN',7698,DATE'1981-09-28',1250,1400,30);
insert into emp values
   (7698,'BLAKE','MANAGER',7839,DATE'1981-05-1',2850,NULL,30);
insert into emp values
   (7782,'CLARK','MANAGER',7839,DATE'1981-06-9',2450,NULL,10);
insert into emp values
   (7788,'SCOTT','ANALYST',7566,DATE'1981-06-9',3000,NULL,20);
insert into emp values
   (7839,'KING','PRESIDENT',NULL,DATE'1981-11-17',5000,NULL,10);
insert into emp values
   (7844,'TURNER','SALESMAN',7698,DATE'1981-09-8',1500,0,30);
insert into emp values
   (7876,'ADAMS','CLERK',7788,DATE'1981-06-9',1100,NULL,20);
insert into emp values
   (7900,'JAMES','CLERK',7698,DATE'1981-12-3',950,NULL,30);
insert into emp values
   (7902,'FORD','ANALYST',7566,DATE'1981-12-3',3000,NULL,20);
insert into emp values
   (7934,'MILLER','CLERK',7782,DATE'1982-01-23',1300,NULL,10);

DROP TABLE dept;
create table dept(
   deptno     int not null,
   dname      varchar(10),
   loc        varchar(9));

insert into dept values
   (10,'ACCOUNTING','NEW YORK');
insert into dept values
   (20,'RESEARCH','DALLAS');
insert into dept values
   (30,'SALES','CHICAGO');
insert into dept values
   (40,'OPERATIONS','BOSTON');

DROP TABLE finderEnum;
create table finderEnum(
   id          varchar(10),
   bal         float not null);

insert into finderEnum values
   ('PK1',  0);
insert into finderEnum values
   ('PK2',  0);
insert into finderEnum values
   ('PK3',  0);
insert into finderEnum values
   ('PK4',  0);
insert into finderEnum values
   ('PK5',  0);
insert into finderEnum values
   ('PK6',  1);
insert into finderEnum values
   ('PK7',  1);
insert into finderEnum values
   ('PK8',  1);
insert into finderEnum values
   ('PK9',  1);
insert into finderEnum values
   ('PK10', 1);

DROP TABLE StockTable;
create table StockTable(
   symbol      varchar(10),
   price       float,
   yearHigh    float,
   yearLow     float,
   volume      int);

DROP TABLE Accounts;
create table Accounts (
   acct_id varchar(50) constraint pk_acct primary key, 
   bal numeric, 
   type varchar(50), 
   cust_name varchar(50));

DROP TABLE Customers;
create table Customers (
   cust_name varchar(50) constraint pk_cust primary key, 
   acct_id varchar(50), 
   cust_age integer, 
   cust_level integer, 
   cust_last date);

DROP TABLE CUSTOMER_ACCOUNTS;
create table CUSTOMER_ACCOUNTS (
   cust_name varchar(50), 
   acct_id varchar(50));



# Defines a simple schema and populates it with some example values.
# The queries in the rdbmsrealm.properties file in this directory are
# made against this schema.

# This schema is not very efficient or flexible (for example, it
# doesn't support empty groups or ACLs, and it forces us to make group
# operations undesirably slow).  It would make more sense to maintain
# tables of users and groups mapping name to ID, and then use the
# numeric IDs in all other tables.  We maintain the current schema for
# backwards compatibility, but you may wish to modify it before any
# kind of serious use.



# Note that these DROP requests will fail the very first time.

DROP TABLE aclentries;
DROP TABLE groupmembers;
DROP TABLE users;

CREATE TABLE aclentries (A_NAME varchar(255), A_PRINCIPAL varchar(255), A_PERMISSION varchar(255));
CREATE TABLE groupmembers(GM_GROUP varchar(255), GM_MEMBER varchar(255));
CREATE TABLE users (U_NAME varchar(255), U_PASSWORD varchar(255));

insert into users values ('anno',     'anno');
insert into users values ('bob',      'bob');
insert into users values ('bryan',    'bryan');
insert into users values ('francine', 'francine');
insert into users values ('jason',    'jason');
insert into users values ('kevin',    'kevin');
insert into users values ('mike',     'mike');
insert into users values ('scott',    'scott');

insert into groupmembers values('engineering', 'anno');
insert into groupmembers values('engineering', 'bryan');
insert into groupmembers values('engineering', 'francine');
insert into groupmembers values('engineering', 'sysadmin');
insert into groupmembers values('marketing',   'mike');
insert into groupmembers values('marketing',   'scott');
insert into groupmembers values('sales',       'jason');
insert into groupmembers values('sysadmin',    'kevin');

insert into aclentries values ('disk',          'engineering', 'read');
insert into aclentries values ('disk',          'engineering', 'write');
insert into aclentries values ('disk',          'marketing',   'read');
insert into aclentries values ('disk',          'sales',       'execute');
insert into aclentries values ('disk',          'scott',       'read');
insert into aclentries values ('fancy printer', 'bob',         'print');
insert into aclentries values ('fancy printer', 'marketing',   'print');
insert into aclentries values ('old printer',   'engineering', 'print');
insert into aclentries values ('old printer',   'sysadmin',    'print');


# SAMPLE ENTRIES of WebLogic ACL's  

# Sample ACL for a registered servlet
insert into aclentries values ('weblogic.servlet.helloWorld', 'engineering', 'execute');

