package examples.webservices.rpc.javaClient;

import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;

import weblogic.soap.WebServiceProxy;
import weblogic.soap.SoapMethod;

/**
 * This class demonstrates a java client consuming an XMethod WebService.
 *
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class XMethodClient{

  public static void main( String[] arg ) throws Exception{
    Properties h = new Properties();

    h.put(Context.INITIAL_CONTEXT_FACTORY,
         "weblogic.soap.http.SoapInitialContextFactory");
    h.put("weblogic.soap.verbose", "true" );

    Context context = new InitialContext(h);

    WebServiceProxy proxy = (WebServiceProxy)context.lookup(
       "http://www.xmethods.net/sd/TemperatureService.wsdl" );

    System.out.println( proxy );

    SoapMethod method = proxy.getMethod( "getTemp" );

    String aZipCode = "90210";
    Float Temperature = (Float)method.invoke(new Object[]{aZipCode});
    System.out.println("Temperature for " + aZipCode + " is " + Temperature.floatValue());
  }

}


