package webFramework.actions;

/**
 * Created and returned by an Action. Specifies the JSP page to use
 * and the values to pass to it (Values to generate content from, 
 * oldFormValues values that were entered into the form, and a Message)
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */


public class ActionResult {
    private String jsp;
    private Object values;
    private String message;
    private Object oldFormValues;

    public ActionResult(String jsp) {
	this.jsp = jsp;
    }

    public void setValues(Object values) {
	this.values = values;
    }

    public void setMessage(String message) {
	this.message = message;
    }

    public void setOldFormValues(Object oldFormValues) {
	this.oldFormValues = oldFormValues;
    }

    public String getJSP() {
	return jsp;
    }

    /**
     * Return the bean to generate dynamic from
     * 
     * @return 
     */
    public Object getValues() {
	return values;
    }

    /**
     * Return the message to display
     * 
     * @return 
     */
    public String getMessage() {
	return message;
    }

    /**
     * Return the old form values
     * 
     * @return 
     */
    public Object getOldFormValues() {
	return oldFormValues;
    }
}
