package webFramework.actions;

/**
 * Defines execute() to call a check() method before calling performAction()
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public abstract class BaseAction implements Action {
    /**
     * If check() returns an ActionResult then return else call performAction()
     * 
     * @return 
     */
    public ActionResult execute() {
	ActionResult r = check();
	if (r != null) {
	    return r;
	}
	return performAction();
    }

    /**
     * Subclasses must implement this
     * 
     * @return 
     */
    protected abstract ActionResult performAction();

    /**
     * Returns null. Subclasses can override this. 
     * 
     * @return 
     */
    protected ActionResult check() {
	return null;
    }
}

