package webFramework.deviceManagement;

import webFramework.util.*;

import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * Parser for categories. 
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
   
class CategoryParser extends DefaultReaderStackElement {
	DeviceCategory category = new DeviceCategory();
	private DeviceSpecManager dsm;

	public CategoryParser(DeviceSpecManager dsm) {
	    this.dsm = dsm;
	}

	public void startElement(ReaderStack stack, java.lang.String uri,
			String localName, String rawName, 
			Attributes attributes) throws SAXException {

		stack.push(new PropertyParser(category, localName));
	}

	public void endElement(ReaderStack stack, String uri, String localName,
			String rawName) throws SAXException {

	    if (localName.equals("category")) {
		dsm.addCategory(category);
		stack.pop();
	    }
	}
}


