package webFramework.deviceManagement;

import java.util.*;
import java.io.*;
import javax.servlet.http.*;

/**
 * Specifies the Device class for all devices to follow.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class Device extends DeviceCategoryItem {
    private String acceptPattern;
    private String userAgentPattern;
    private String contentType;
    private Class initializerClass;
    private Device parentDevice;

    private int pixelWidth = -1;
    private int pixelHeight = -1;
    private int charWidth = -1;
    private int charHeight = -1;

    private String subscriberId;

    private static final boolean debug = false;

    public void setSubscriberId(String subscriberId) {
	this.subscriberId = subscriberId;
    }

    public String getSubscriberId() {
	return subscriberId;
    }

    public void setPixelWidth(int pixelWidth) {
	this.pixelWidth = pixelWidth;
    }

    public int getPixelWidth() {
	return pixelWidth;
    }


    public void setPixelHeight(int pixelHeight) {
	this.pixelHeight = pixelHeight;
    }

    public int getPixelHeight() {
	return pixelHeight;
    }

    public void setCharWidth(int charWidth) {
	this.charWidth = charWidth;
    }

    public int getCharWidth() {
	return charWidth;
    }



    public void setCharHeight(int charHeight) {
	this.charHeight = charHeight;
    }

    public int getCharHeight() {
	return charHeight;
    }

    public Device() {
    }

    public Device(String name, String acceptPattern, String userAgentPattern,
		      String contentType) {
	super(name);
	this.acceptPattern = acceptPattern;
	this.userAgentPattern = userAgentPattern;
	this.contentType = contentType;
    }

    public void setAcceptPattern(String acceptPattern) {
	this.acceptPattern = acceptPattern.equals("*") ? null : acceptPattern;
    }

    public void setUserAgentPattern(String userAgentPattern) {
	this.userAgentPattern = userAgentPattern.equals("*") ? null : userAgentPattern;
    }

    public void setContentType(String contentType) {
	this.contentType = contentType;
    }

    public void setInitializerClass(Class initializerClass) {
	this.initializerClass = initializerClass;
    }

    public Device(String name, DeviceCategory parent, String acceptPattern,
			String userAgentPattern, String contentType) {

	super(name, parent);
	this.acceptPattern = acceptPattern;
	this.userAgentPattern = userAgentPattern;
	this.contentType = contentType;
    }

    public Device(String name, Vector parents, String acceptPattern, 
			String userAgentPattern, String contentType) {

	super(name, parents);
 	this.acceptPattern = acceptPattern;
	this.userAgentPattern = userAgentPattern;
	this.contentType = contentType;
    }
    
    public boolean match(HttpServletRequest request) {

	String userAgentHeader = request.getHeader("user-agent");
	String acceptHeader = request.getHeader("accept");

	if (debug) {
		System.out.println("matching: " + acceptHeader + ", "
				+ userAgentHeader);
		System.out.println("matching: " + acceptPattern + ", "
				+ userAgentPattern);
	}

	return (acceptPattern == null || acceptHeader.indexOf(acceptPattern)
		!= -1) && (userAgentPattern == null || 
		userAgentHeader.indexOf(userAgentPattern) != -1);
    }

    public String getContentType() {
	return contentType;
    }

    public Device make(HttpServletRequest request) {
	try {
	    Device newDevice = (Device)clone();
	    newDevice.initialize(request);
	    newDevice.parentDevice = this;
	    return newDevice;
	} catch (CloneNotSupportedException e) {
	    e.printStackTrace();
	    return null;
	}
    }

    public void initialize(HttpServletRequest request) {
	if (initializerClass != null)
	    try {
	    ((DeviceInitializer)initializerClass.newInstance()).initialize(this, request);
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }

    public boolean is(Device other) {
	return this == other || parentDevice == other;
    }

    // Adhoc attributes describing device behavior
    // Perhaps these should be dynamic attributes.

    private boolean displaysCardTitle = true;
    private boolean displaysInputTitle = false;
    private boolean doAcceptVisible = false;
    private boolean doPrevRequired = true;
    private boolean newLineAfterInput = false;
    private boolean inlineImages = false;
    private boolean onEnterForwardHangs = false;
    private boolean useSelectForMenus = false;

    public boolean getDisplaysCardTitle() {
	return displaysCardTitle;
    }

    public void setDisplaysCardTitle(boolean displaysCardTitle) {
	this.displaysCardTitle = displaysCardTitle;
    }
    
    public boolean setDisplaysInputTitle() {
	return displaysInputTitle;
    }

    public void setDisplaysInputTitle(boolean displaysInputTitle) {
	this.displaysInputTitle = displaysInputTitle;
    }
}

