package webFramework.deviceManagement;

import java.util.*;

/**
 * DeviceCategory.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class DeviceCategory extends DeviceCategoryItem {
    private static final boolean debug = false;

    protected DeviceCategory() {
	super();
    }

    protected DeviceCategory(String name) {
	super(name);
    }

    protected DeviceCategory(String name, DeviceCategory parent) {
	super(name,parent);
    }

    protected DeviceCategory(String name, Vector parents) {
	super(name, parents);
    }

    public boolean isParentOf(DeviceCategoryItem item) {
	return item.getParents().contains(this);
    }

    public boolean isInstance(DeviceCategoryItem item) {
	if (debug) {
		System.out.println("isInstance: " + this + ", " + item);
	}
	Enumeration p = item.getParents().elements();
	while (p.hasMoreElements()) {
	    DeviceCategory c = (DeviceCategory)p.nextElement();
	    //System.out.println("got parent: " + c);
	    if (c == this)
		return true;
	    if (isInstance(c))
		return true;
	}
	return false;
    }

    public void addChild(DeviceCategoryItem child) {
	// Not currently doing anything
    }

}
