package webFramework.deviceManagement;

import java.util.*;
import java.io.*;

/**
 * DeviceCategoryItem.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public abstract class DeviceCategoryItem implements Cloneable {
    protected String name;
    protected Vector parents = new Vector();

    protected DeviceCategoryItem() {
    }

    protected DeviceCategoryItem(String name) {
	this.name = name;
    }

    protected DeviceCategoryItem(String name, DeviceCategory parent) {
	this(name);
	parent.addChild(this);
	parents.addElement(parent);
    }

    protected DeviceCategoryItem(String name, Vector parents) {
	this(name);
	setParents(parents);
    }

    public void setParents(Vector parents) {
	this.parents = parents;
	Enumeration e = parents.elements();
	while (e.hasMoreElements()) {
	    DeviceCategory c = (DeviceCategory)e.nextElement();
	    c.addChild(this);
	}
    }

    public void setName(String name) {
	this.name = name;
    }

    public String getName() {
	return name;
    }

    public Vector getParents() {
	return parents;
    }

    public String toString() {
	return getClass() + "[" + name + "]";
    }
}

