package webFramework.deviceManagement;

import webFramework.util.*;
 
import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * DeviceDefinitionParser.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
    
class DeviceDefinitionsParser extends DefaultReaderStackElement {

	private DeviceSpecManager dsm;

	public DeviceDefinitionsParser(DeviceSpecManager dsm) {
	    this.dsm = dsm;
	}

	public void startElement(ReaderStack stack, java.lang.String uri,
			String localName, String rawName,
			Attributes attributes) throws SAXException {

	    if (localName.equals("category")) {
		stack.push(new CategoryParser(dsm));
	    } else if (localName.equals("device")) {
		stack.push(new DeviceParser(dsm));	    
	    }
	}

	public void endElement(ReaderStack stack, String uri, String localName,
			String rawName) throws SAXException {

	    if (localName.equals("definitions"))
		stack.pop();
	}

}

