package webFramework.deviceManagement;

/**
 * DeviceManager detects the device type
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class DeviceManager {

    private String acceptHeader;
    private String userAgentHeader;

    private String contentType = "text/html";
    private String contentDir = "html";

    private static final boolean debug = false;

    public DeviceManager() {
    }

    public DeviceManager(String acceptHeader, String userAgentHeader) {
	this.acceptHeader = acceptHeader;
	this.userAgentHeader = userAgentHeader;

	// This can be turned off.  Left on by default, useful for debugging.
	if (debug) {
		System.out.println("userAgentHeader: " + userAgentHeader);
		System.out.println("Accept: " + acceptHeader);
	}
	compute();
    }


    public String getContentDir() {
	return contentDir;
    }

    public String getContentType() {
	return contentType;
    }

    /*
     * This can be improved.  Add new userAgent strings here.
     */
    private void compute() {
	String[][] userAgents = {{"text/vnd.wap.wml", "UP.Browser", "wml"}, 
				 {"text/vnd.wap.wml", "Nokia", "wml"},
				 {"text/vnd.wap.wml", "R320", "wml"},
				 {"text/vnd.wap.wml", null, "wml"},
				 {"text/vxml", null, "vxml"}};

	if (userAgentHeader == null) userAgentHeader = "";
	if (acceptHeader == null) acceptHeader = "";
		
	for (int i = 0 ; i < userAgents.length; i++) {
	    String[] entry = userAgents[i];
	    String desiredAccept = entry[0];
	    String desiredUserAgent = entry[1];

	    if ((desiredAccept == null || acceptHeader.indexOf(desiredAccept)
		!= -1) && (desiredUserAgent == null || 
		userAgentHeader.indexOf(desiredUserAgent) != -1)) {

		contentType = desiredAccept;
		contentDir = entry[2];
		return;
	    }
	}
    }

}
