package webFramework.deviceManagement;

import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.util.*;
import webFramework.util.*;

/**
 * DeviceOrCategoryParser.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class DeviceOrCategoryParser extends DefaultReaderStackElement {

	private DeviceSpecManager dsm;
	private DeviceMapping device;

	public DeviceOrCategoryParser(DeviceSpecManager dsm,
				DeviceMapping device) {

	    this.dsm = dsm;
	    this.device = device;
	}

	public void characters(ReaderStack stack, char[] ch, int start,
				int length) throws SAXException {

	    // sets the value of the specified property
	    try {
  	      String value = new String(ch, start, length);
	      device.setDeviceOrCategory(dsm.findItem(value));
            } catch (Exception e) {
		e.printStackTrace();
	    }
	}
	
	public void endElement(ReaderStack stack, String uri, String localName,
				String rawName) throws SAXException {
	    stack.pop();
	}

}

