package webFramework.deviceManagement;

import webFramework.util.*;
import java.util.*;
import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * DeviceParser.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
    
class DeviceParser extends DefaultReaderStackElement {
	Device device = new Device();
	private DeviceSpecManager dsm;
	private Vector parents = new Vector();
	
	public DeviceParser(DeviceSpecManager dsm) {
	    this.dsm = dsm;
	}

	public void startElement(ReaderStack stack, java.lang.String uri,
				String localName, String rawName,
				Attributes attributes) throws SAXException {

	    if (localName.equals("parent")) {
		stack.push(new ParentParser(dsm, parents));
	    } else
		stack.push(new PropertyParser(device, localName));
	}

	public void endElement(ReaderStack stack, String uri, String localName,
				String rawName) throws SAXException {

	    if (localName.equals("device")) {
		device.setParents(parents);
		dsm.addDevice(device);
		stack.pop();
	    }
	}

}

