package webFramework.deviceManagement;

/**
 * Matches a device (user-agent, accept)
 * Knows the contentType, contentDir, templateName
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class DeviceSpec {

    private String acceptPattern;
    private String userAgentPattern;

    private String contentType;
    private String contentDir;
    private String templateName;

    public DeviceSpec(String acceptPattern, String userAgentPattern,
			String contentType, String contentDir, 
			String templateName) {

	this.acceptPattern = acceptPattern;
	this.userAgentPattern = userAgentPattern;
	this.contentType = contentType;
	this.contentDir = contentDir;
	this.templateName = templateName;
    }

    /**
     * Returns true if the request is for this device
     * 
     * @param acceptHeader
     * @param userAgentHeader
     * @return 
     */
    public boolean match(String acceptHeader, String userAgentHeader) {

	return (acceptPattern == null || acceptHeader.indexOf(acceptPattern)
		!= -1) && (userAgentPattern == null || 
		userAgentHeader.indexOf(userAgentPattern) != -1);
    }

    public String getContentType() {
	return contentType;
    }

    public String getContentDir() {
	return contentDir;
    }

    public String getTemplateName() {
	return templateName;
    }

}
