package webFramework.deviceManagement;

import java.util.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.beans.*;
import java.lang.reflect.*;

import webFramework.util.*;

/**
 * DeviceSpecManager.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class DeviceSpecManager {
	
        private static final boolean debug = false;

	public static DeviceSpecManager getInstance(ServletContext context) {

		DeviceSpecManager dsm = (DeviceSpecManager)context.getAttribute("dsm");
		if (dsm == null) {
			dsm = new DeviceSpecManager(context);
			context.setAttribute("dsm", dsm);
		}
		return dsm;
	}

	private ServletContext context;

	DeviceSpecManager(ServletContext context) {
		this.context = context;
	}

	private Vector deviceList = new Vector();

	public Device findDevice(HttpServletRequest request) 
		throws IOException {
	
		readDevicesAndCategories("CategoryDefinitions.xml",
				"DeviceDefinitions.xml");
		Enumeration devices = deviceList.elements();
 
		if (debug)
		  System.out.println("findDevice:"+request.getHeader("user-agent"));

		while (devices.hasMoreElements()) {
			Object item = devices.nextElement();
			if (item instanceof Device) {
				Device device = (Device)item;
				if (device.match(request)) {
				  if (debug)
				    System.out.println("Device = " + device);
				  return device.make(request);
				}
			}
		}
		return null;
	}

	private void readDevicesAndCategories(String categoryFilename,
				String deviceFileName) throws IOException {

		devicesAndCategories.clear();
		deviceList = new Vector();
		readFile(categoryFilename);
		readFile(deviceFileName);
	}

	private void readFile(String fileName) throws IOException {

		ConfigFileReader cfr = new ConfigFileReader
			(context.getResourceAsStream("WEB-INF/" + fileName),
			new DeviceDefinitionsParser(this));
		if (debug)
		  System.out.println("context:"+context);

		try {
		    cfr.read();
		} catch (Exception e) {
		    e.printStackTrace();
		}
	}

	private Hashtable devicesAndCategories = new Hashtable();

	public DeviceCategory findCategory(String name) {
		return(DeviceCategory)devicesAndCategories.get(name);
	}

	public DeviceCategoryItem findItem(String name) {
		return(DeviceCategoryItem)devicesAndCategories.get(name);
	}

	public void addDevice(Device device) {
		deviceList.addElement(device);
		devicesAndCategories.put(device.getName(), device);
	}

	public void addCategory(DeviceCategory category) {
		devicesAndCategories.put(category.getName(), category);
	}

}

