package webFramework.deviceManagement;

import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.util.*;
import webFramework.util.*;

/**
 * ParentParser.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class ParentParser extends DefaultReaderStackElement {

	Vector parents;
	private DeviceSpecManager dsm;

	public ParentParser(DeviceSpecManager dsm, Vector parents) {
	    this.dsm = dsm;
	    this.parents = parents;
	}

	public void characters(ReaderStack stack, char[] ch, int start,
		int length) throws SAXException {

	    // sets the value of the specified property
	    try {
	    String value = new String(ch, start, length);
	    parents.addElement(dsm.findCategory(value));
            } catch (Exception e) {
		e.printStackTrace();
	    }
	}
	
	public void endElement(ReaderStack stack, String uri,
		String localName, String rawName) throws SAXException {
	    stack.pop();
	}

}
