package webFramework.deviceManagement;

import javax.servlet.http.*;

/**
 * UPInitializer.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class UPInitializer implements DeviceInitializer {

    private static final boolean debug = false;

    public void initialize(Device device, HttpServletRequest request) {

	if (debug)
	  System.out.println("Initializing for UP");

	String screenPixels = request.getHeader("X-UP-DEVCAP-SCREENPIXELS");
	String screenChars = request.getHeader("X-UP-DEVCAP-SCREENCHARS");
	String subscriberId = request.getHeader("X-UP-SUBNO");
	int[] pixelDims = splitCSVInt(screenPixels);
	int[] charDims = splitCSVInt(screenChars);

	device.setPixelWidth(pixelDims[0]);
	device.setPixelHeight(pixelDims[1]);
	device.setCharWidth(charDims[0]);
	device.setCharHeight(charDims[1]);
	device.setSubscriberId(subscriberId);

	if (debug) {
	  System.out.println("Screen width: " + pixelDims[0]);
	  System.out.println("Screen height: " + pixelDims[1]);
	  System.out.println("Screen width in chars: " + charDims[0]);
	  System.out.println("Screen height in chars: " + charDims[1]);
	}
    }

    private int[] splitCSVInt(String x) {
	if (x == null)
	    return new int[]{-1, -1};
	x = x.trim();
	if (x.equals(""))
	    return new int[]{-1, -1};
	int index = x.indexOf(",");
	return new int[]{Integer.parseInt(x.substring(0,index)), 
	    		 Integer.parseInt(x.substring(1+index))};
    }

}

