package webFramework.jspSelection;

import webFramework.deviceManagement.*;

/**
 * JSPMapping.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class JSPMapping extends DeviceMapping {
    private String jsp;
    private String dir;

    private static final boolean debug = false;

    public JSPMapping() {
    }

    public JSPMapping(String jsp, DeviceCategoryItem item, String dir) {
	this.jsp = jsp;
	this.item = item;
	this.dir = dir;
    }

    public void setJsp(String jsp) {
	this.jsp = jsp.equals("*") ? null : jsp;
    }

    public void setDirectory(String directory) {
	this.dir = directory;
    }

    public boolean match(String jspName, Device device) {

	if (debug) {
		System.out.println("JSP match: " + jspName + ", " + device);
		System.out.println("JSP match: " + jsp + ", " + item);
	}

	if (jsp != null && !jsp.equals(jspName))
	    return false;

	return super.match(device);
    }

    public String getDirectory() {
	return dir;
    }

    public String toString() {
	return getClass().getName() + "[" + jsp + "," + item + "," + dir + "]";
    }

}
