package webFramework.jspSelection;

import webFramework.util.*;
import webFramework.deviceManagement.*;
 
import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * JSPRulesParser.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
    
class JSPRulesParser extends DefaultReaderStackElement {

	private DeviceSpecManager dsm;
	private JSPSelectionRuleManager jsprm;

	public JSPRulesParser(JSPSelectionRuleManager jsprm,
				DeviceSpecManager dsm) {

	    this.dsm = dsm;
	    this.jsprm = jsprm;
	}

	public void startElement(ReaderStack stack, java.lang.String uri,
				String localName, String rawName,
				Attributes attributes) throws SAXException {

	    if (localName.equals("jsp-selection-rule")) {
		stack.push(new JSPSelectionRuleParser(jsprm, dsm));
	    }
	}

	public void endElement(ReaderStack stack, String uri, String localName,
				String rawName) throws SAXException {

	    if (localName.equals("jsp-selection-rules"))
		stack.pop();
	}

}

