package webFramework.jspSelection;

import java.util.*;
import java.io.*;
import javax.servlet.*;

import webFramework.deviceManagement.*;
import webFramework.util.*;

/**
 * JSPSelectionRuleManager.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class JSPSelectionRuleManager {

    private static final boolean debug = false;

    public static JSPSelectionRuleManager getInstance(ServletContext context) {

	JSPSelectionRuleManager dsm = (JSPSelectionRuleManager)context.getAttribute("jsm");

	if (dsm == null) {
	    dsm = new JSPSelectionRuleManager(context);
	    context.setAttribute("jsm", dsm);
	}
	return dsm;
    }

    private ServletContext context;

    JSPSelectionRuleManager(ServletContext context) {
	this.context = context;
    }

    private Vector jspMappings = new Vector();

    private void readDeviceToJSPMappings(String fileName) throws IOException {

	jspMappings = new Vector();
	ConfigFileReader cfr = new ConfigFileReader
		(context.getResourceAsStream("WEB-INF/" + fileName),
		new JSPRulesParser(this, DeviceSpecManager.getInstance(context)));
	try {
	    cfr.read();
	} catch (Exception e) {
	    e.printStackTrace();
	}
	
    }

    public void addMapping(JSPMapping jspMapping) {
	jspMappings.addElement(jspMapping);
    }

    public JSPMapping findJSPMapping(String jspName, Device device)
			throws IOException {

	readDeviceToJSPMappings("JSPSelectionRules.xml");

	Enumeration e = jspMappings.elements();

	while (e.hasMoreElements()) {
	    JSPMapping jspMapping = (JSPMapping)e.nextElement();
	    if (jspMapping.match(jspName, device)) {
		if (debug)
		  System.out.println("Selected JSP = " + jspMapping);
		return jspMapping;
	    }
	}
	return null;
    }

 }

